import { useParams } from '@magicjs.dev/frontend';
import React, { useState } from 'react';

export default function () {
    const [keywordInput, setKeyword] = useState<any>(``);
    const [isModalOpen, setIsModalOpen] = useState(false);
    const { keyword } = useParams();

    React.useEffect(() => {
        const decodedKeyword = decodeURIComponent(keyword);
        if (keyword) {
            setKeyword(`${decodedKeyword}`)
        } else {
            setKeyword('')
        }
    }, [keyword])

    const openModal = () => {
        setIsModalOpen(true);
    };

    const closeModal = () => {
        setIsModalOpen(false);
        setKeyword("");
    };

    return {
        keywordInput, setKeyword,
        openModal,
        closeModal,
        isModalOpen
    }
}