import { createSrc, useParams } from '@magicjs.dev/frontend';
import React, { useState } from 'react';
import searchResult from "./search-results.server"
import getProductImage from "./get-image.server";

export default function () {
    const [items, setItems] = useState<any>([])
    const [loading, setLoading] = useState<any>(true)
    const { keyword } = useParams();
    const imageSrc = createSrc(getProductImage);

    React.useEffect(() => {
        const decodedKeyword = decodeURIComponent(keyword);
        searchResult(decodedKeyword).then((res) => {
            setItems(res)
            setLoading(false)
        }).catch(() => {
            setLoading(false)
        })
    }, [keyword])

    return {
        keyword,
        items,
        loading,
        imageSrc
    }
}