import { useLogin } from '@magicjs.dev/frontend';
import React, { useState, useRef } from 'react';

export default function () {
    const [isLogoutModalOpen, setIsLogoutModalOpen] = useState(false);
    const [loading, setLoading] = useState(false);
    const [isSidebarOpen, setIsSidebarOpen] = useState(false);
    const { logout } = useLogin();
    const sidebarRef = useRef(null);
    const openSidebarButtonRef = useRef(null);

    const handleLogout = React.useCallback(() => {
        setLoading(true)
        logout().then(() => {
            setIsLogoutModalOpen(false)
        }).catch(() => {
            setLoading(false)
        });
    }, [])

    React.useEffect(() => {
        const handleOutsideClick = (e) => {
            if (
                sidebarRef.current &&
                openSidebarButtonRef.current
            ) {
                setIsSidebarOpen(false);
            }
        };

        document.addEventListener('click', handleOutsideClick);

        return () => {
            document.removeEventListener('click', handleOutsideClick);
        };
    }, []);

    const toggleSidebar = (e) => {
        e.stopPropagation();
        setIsSidebarOpen((prevState) => !prevState);
    };

    return {
        isLogoutModalOpen,
        loading,
        setIsLogoutModalOpen,
        handleLogout,
        isSidebarOpen,
        sidebarRef,
        openSidebarButtonRef,
        toggleSidebar
    }
}