"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Union = void 0;
var stream_1 = require("stream");
var _a = require('fs-monkey/lib/util/lists'), fsAsyncMethods = _a.fsAsyncMethods, fsSyncMethods = _a.fsSyncMethods;
var SPECIAL_METHODS = new Set([
    'existsSync',
    'readdir',
    'readdirSync',
    'createReadStream',
    'createWriteStream',
    'watch',
    'watchFile',
    'unwatchFile',
]);
var createFSProxy = function (watchers) {
    return new Proxy({}, {
        get: function (_obj, property) {
            var e_1, _a;
            var funcCallers = [];
            var prop;
            try {
                for (var watchers_1 = __values(watchers), watchers_1_1 = watchers_1.next(); !watchers_1_1.done; watchers_1_1 = watchers_1.next()) {
                    var watcher = watchers_1_1.value;
                    prop = watcher[property];
                    // if we're a function we wrap it in a bigger caller;
                    if (typeof prop === 'function') {
                        funcCallers.push([watcher, prop]);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (watchers_1_1 && !watchers_1_1.done && (_a = watchers_1.return)) _a.call(watchers_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (funcCallers.length) {
                return function () {
                    var e_2, _a;
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    try {
                        for (var funcCallers_1 = __values(funcCallers), funcCallers_1_1 = funcCallers_1.next(); !funcCallers_1_1.done; funcCallers_1_1 = funcCallers_1.next()) {
                            var _b = __read(funcCallers_1_1.value, 2), watcher = _b[0], func = _b[1];
                            func.apply(watcher, args);
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (funcCallers_1_1 && !funcCallers_1_1.done && (_a = funcCallers_1.return)) _a.call(funcCallers_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                };
            }
            else {
                return prop;
            }
        },
    });
};
var fsPromisesMethods = [
    'access',
    'copyFile',
    'open',
    'opendir',
    'rename',
    'truncate',
    'rmdir',
    'mkdir',
    'readdir',
    'readlink',
    'symlink',
    'lstat',
    'stat',
    'link',
    'unlink',
    'chmod',
    'lchmod',
    'lchown',
    'chown',
    'utimes',
    'realpath',
    'mkdtemp',
    'writeFile',
    'appendFile',
    'readFile',
];
/**
 * Union object represents a stack of filesystems
 */
var Union = /** @class */ (function () {
    function Union() {
        var e_3, _a, e_4, _b, e_5, _c, e_6, _d;
        var _this = this;
        this.fss = [];
        this.ReadStream = stream_1.Readable;
        this.WriteStream = stream_1.Writable;
        this.promises = {};
        this.unwatchFile = function () {
            var e_7, _a;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            try {
                for (var _b = __values(_this.fss), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var fs = _c.value;
                    try {
                        fs.unwatchFile.apply(fs, args);
                    }
                    catch (e) {
                        // dunno what to do here...
                    }
                }
            }
            catch (e_7_1) { e_7 = { error: e_7_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_7) throw e_7.error; }
            }
        };
        this.watch = function () {
            var e_8, _a;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var watchers = [];
            try {
                for (var _b = __values(_this.fss), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var fs = _c.value;
                    try {
                        var watcher = fs.watch.apply(fs, args);
                        watchers.push(watcher);
                    }
                    catch (e) {
                        // dunno what to do here...
                    }
                }
            }
            catch (e_8_1) { e_8 = { error: e_8_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_8) throw e_8.error; }
            }
            // return a proxy to call functions on these props
            return createFSProxy(watchers);
        };
        this.watchFile = function () {
            var e_9, _a;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            try {
                for (var _b = __values(_this.fss), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var fs = _c.value;
                    try {
                        fs.watchFile.apply(fs, args);
                    }
                    catch (e) {
                        // dunno what to do here...
                    }
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_9) throw e_9.error; }
            }
        };
        this.existsSync = function (path) {
            var e_10, _a;
            try {
                for (var _b = __values(_this.fss), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var fs = _c.value;
                    try {
                        if (fs.existsSync(path)) {
                            return true;
                        }
                    }
                    catch (e) {
                        // ignore
                    }
                }
            }
            catch (e_10_1) { e_10 = { error: e_10_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_10) throw e_10.error; }
            }
            return false;
        };
        this.readdir = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var lastarg = args.length - 1;
            var cb = args[lastarg];
            if (typeof cb !== 'function') {
                cb = null;
                lastarg++;
            }
            var lastError = null;
            var result = new Map();
            var iterate = function (i, error) {
                if (i === void 0) { i = 0; }
                if (error) {
                    error.prev = lastError;
                    lastError = error;
                }
                // Already tried all file systems, return the last error.
                if (i >= _this.fss.length) {
                    // last one
                    if (cb) {
                        cb(error || Error('No file systems attached.'));
                    }
                    return;
                }
                // Replace `callback` with our intermediate function.
                args[lastarg] = function (err, resArg) {
                    var e_11, _a;
                    if (result.size === 0 && err) {
                        return iterate(i + 1, err);
                    }
                    if (resArg) {
                        try {
                            for (var resArg_1 = __values(resArg), resArg_1_1 = resArg_1.next(); !resArg_1_1.done; resArg_1_1 = resArg_1.next()) {
                                var res = resArg_1_1.value;
                                result.set(_this.pathFromReaddirEntry(res), res);
                            }
                        }
                        catch (e_11_1) { e_11 = { error: e_11_1 }; }
                        finally {
                            try {
                                if (resArg_1_1 && !resArg_1_1.done && (_a = resArg_1.return)) _a.call(resArg_1);
                            }
                            finally { if (e_11) throw e_11.error; }
                        }
                    }
                    if (i === _this.fss.length - 1) {
                        return cb(null, _this.sortedArrayFromReaddirResult(result));
                    }
                    else {
                        return iterate(i + 1, error);
                    }
                };
                var j = _this.fss.length - i - 1;
                var fs = _this.fss[j];
                var func = fs.readdir;
                if (!func)
                    iterate(i + 1, Error('Method not supported: readdir'));
                else
                    func.apply(fs, args);
            };
            iterate();
        };
        this.readdirSync = function () {
            var e_12, _a;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var lastError = null;
            var result = new Map();
            for (var i = _this.fss.length - 1; i >= 0; i--) {
                var fs = _this.fss[i];
                try {
                    if (!fs.readdirSync)
                        throw Error("Method not supported: \"readdirSync\" with args \"".concat(args, "\""));
                    try {
                        for (var _b = (e_12 = void 0, __values(fs.readdirSync.apply(fs, args))), _c = _b.next(); !_c.done; _c = _b.next()) {
                            var res = _c.value;
                            result.set(_this.pathFromReaddirEntry(res), res);
                        }
                    }
                    catch (e_12_1) { e_12 = { error: e_12_1 }; }
                    finally {
                        try {
                            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                        }
                        finally { if (e_12) throw e_12.error; }
                    }
                }
                catch (err) {
                    err.prev = lastError;
                    lastError = err;
                    if (result.size === 0 && !i) {
                        // last one
                        throw err;
                    }
                    else {
                        // Ignore error...
                        // continue;
                    }
                }
            }
            return _this.sortedArrayFromReaddirResult(result);
        };
        this.readdirPromise = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return __awaiter(_this, void 0, void 0, function () {
                var lastError, result, i, fs, _a, _b, res, e_13_1, err_1;
                var e_13, _c;
                return __generator(this, function (_d) {
                    switch (_d.label) {
                        case 0:
                            lastError = null;
                            result = new Map();
                            i = this.fss.length - 1;
                            _d.label = 1;
                        case 1:
                            if (!(i >= 0)) return [3 /*break*/, 13];
                            fs = this.fss[i];
                            _d.label = 2;
                        case 2:
                            _d.trys.push([2, 11, , 12]);
                            if (!fs.promises || !fs.promises.readdir)
                                throw Error("Method not supported: \"readdirSync\" with args \"".concat(args, "\""));
                            _d.label = 3;
                        case 3:
                            _d.trys.push([3, 8, 9, 10]);
                            e_13 = void 0;
                            return [4 /*yield*/, fs.promises.readdir.apply(fs, args)];
                        case 4:
                            _a = (__values.apply(void 0, [_d.sent()])), _b = _a.next();
                            _d.label = 5;
                        case 5:
                            if (!!_b.done) return [3 /*break*/, 7];
                            res = _b.value;
                            result.set(this.pathFromReaddirEntry(res), res);
                            _d.label = 6;
                        case 6:
                            _b = _a.next();
                            return [3 /*break*/, 5];
                        case 7: return [3 /*break*/, 10];
                        case 8:
                            e_13_1 = _d.sent();
                            e_13 = { error: e_13_1 };
                            return [3 /*break*/, 10];
                        case 9:
                            try {
                                if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                            }
                            finally { if (e_13) throw e_13.error; }
                            return [7 /*endfinally*/];
                        case 10: return [3 /*break*/, 12];
                        case 11:
                            err_1 = _d.sent();
                            err_1.prev = lastError;
                            lastError = err_1;
                            if (result.size === 0 && !i) {
                                // last one
                                throw err_1;
                            }
                            else {
                                // Ignore error...
                                // continue;
                            }
                            return [3 /*break*/, 12];
                        case 12:
                            i--;
                            return [3 /*break*/, 1];
                        case 13: return [2 /*return*/, this.sortedArrayFromReaddirResult(result)];
                    }
                });
            });
        };
        this.pathFromReaddirEntry = function (readdirEntry) {
            if (readdirEntry instanceof Buffer || typeof readdirEntry === 'string') {
                return String(readdirEntry);
            }
            return readdirEntry.name;
        };
        this.sortedArrayFromReaddirResult = function (readdirResult) {
            var e_14, _a;
            var array = [];
            try {
                for (var _b = __values(Array.from(readdirResult.keys()).sort()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var key = _c.value;
                    var value = readdirResult.get(key);
                    if (value !== undefined)
                        array.push(value);
                }
            }
            catch (e_14_1) { e_14 = { error: e_14_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_14) throw e_14.error; }
            }
            return array;
        };
        this.createReadStream = function (path) {
            var e_15, _a;
            var lastError = null;
            try {
                for (var _b = __values(_this.fss), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var fs = _c.value;
                    try {
                        if (!fs.createReadStream)
                            throw Error("Method not supported: \"createReadStream\"");
                        if (fs.existsSync && !fs.existsSync(path)) {
                            throw new Error("file \"".concat(path, "\" does not exists"));
                        }
                        var stream = fs.createReadStream(path);
                        if (!stream) {
                            throw new Error('no valid stream');
                        }
                        _this.ReadStream = fs.ReadStream;
                        return stream;
                    }
                    catch (err) {
                        lastError = err;
                    }
                }
            }
            catch (e_15_1) { e_15 = { error: e_15_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_15) throw e_15.error; }
            }
            throw lastError;
        };
        this.createWriteStream = function (path) {
            var e_16, _a;
            var lastError = null;
            try {
                for (var _b = __values(_this.fss), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var fs = _c.value;
                    try {
                        if (!fs.createWriteStream)
                            throw Error("Method not supported: \"createWriteStream\"");
                        fs.statSync(path); //we simply stat first to exit early for mocked fs'es
                        //TODO which filesystem to write to?
                        var stream = fs.createWriteStream(path);
                        if (!stream) {
                            throw new Error('no valid stream');
                        }
                        _this.WriteStream = fs.WriteStream;
                        return stream;
                    }
                    catch (err) {
                        lastError = err;
                    }
                }
            }
            catch (e_16_1) { e_16 = { error: e_16_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_16) throw e_16.error; }
            }
            throw lastError;
        };
        var _loop_1 = function (method) {
            if (!SPECIAL_METHODS.has(method)) {
                // check we don't already have a property for this method
                this_1[method] = function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    return _this.syncMethod(method, args);
                };
            }
        };
        var this_1 = this;
        try {
            for (var fsSyncMethods_1 = __values(fsSyncMethods), fsSyncMethods_1_1 = fsSyncMethods_1.next(); !fsSyncMethods_1_1.done; fsSyncMethods_1_1 = fsSyncMethods_1.next()) {
                var method = fsSyncMethods_1_1.value;
                _loop_1(method);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (fsSyncMethods_1_1 && !fsSyncMethods_1_1.done && (_a = fsSyncMethods_1.return)) _a.call(fsSyncMethods_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        var _loop_2 = function (method) {
            if (!SPECIAL_METHODS.has(method)) {
                // check we don't already have a property for this method
                this_2[method] = function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    return _this.asyncMethod(method, args);
                };
            }
        };
        var this_2 = this;
        try {
            for (var fsAsyncMethods_1 = __values(fsAsyncMethods), fsAsyncMethods_1_1 = fsAsyncMethods_1.next(); !fsAsyncMethods_1_1.done; fsAsyncMethods_1_1 = fsAsyncMethods_1.next()) {
                var method = fsAsyncMethods_1_1.value;
                _loop_2(method);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (fsAsyncMethods_1_1 && !fsAsyncMethods_1_1.done && (_b = fsAsyncMethods_1.return)) _b.call(fsAsyncMethods_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
        var _loop_3 = function (method) {
            if (method === 'readdir') {
                this_3.promises[method] = this_3.readdirPromise;
                return "continue";
            }
            this_3.promises[method] = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return _this.promiseMethod(method, args);
            };
        };
        var this_3 = this;
        try {
            for (var fsPromisesMethods_1 = __values(fsPromisesMethods), fsPromisesMethods_1_1 = fsPromisesMethods_1.next(); !fsPromisesMethods_1_1.done; fsPromisesMethods_1_1 = fsPromisesMethods_1.next()) {
                var method = fsPromisesMethods_1_1.value;
                _loop_3(method);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (fsPromisesMethods_1_1 && !fsPromisesMethods_1_1.done && (_c = fsPromisesMethods_1.return)) _c.call(fsPromisesMethods_1);
            }
            finally { if (e_5) throw e_5.error; }
        }
        try {
            for (var _e = __values(SPECIAL_METHODS.values()), _f = _e.next(); !_f.done; _f = _e.next()) {
                var method = _f.value;
                // bind special methods to support
                // const { method } = ufs;
                this[method] = this[method].bind(this);
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_d = _e.return)) _d.call(_e);
            }
            finally { if (e_6) throw e_6.error; }
        }
    }
    /**
     * Adds a filesystem to the list of filesystems in the union
     * The new filesystem object is added as the last filesystem used
     * when searching for a file.
     *
     * @param fs the filesystem interface to be added to the queue of FS's
     * @returns this instance of a unionFS
     */
    Union.prototype.use = function (fs) {
        this.fss.push(fs);
        return this;
    };
    Union.prototype.syncMethod = function (method, args) {
        var lastError = null;
        for (var i = this.fss.length - 1; i >= 0; i--) {
            var fs = this.fss[i];
            try {
                if (!fs[method])
                    throw Error("Method not supported: \"".concat(method, "\" with args \"").concat(args, "\""));
                return fs[method].apply(fs, args);
            }
            catch (err) {
                err.prev = lastError;
                lastError = err;
                if (!i) {
                    // last one
                    throw err;
                }
                else {
                    // Ignore error...
                    // continue;
                }
            }
        }
    };
    Union.prototype.asyncMethod = function (method, args) {
        var _this = this;
        var lastarg = args.length - 1;
        var cb = args[lastarg];
        if (typeof cb !== 'function') {
            cb = null;
            lastarg++;
        }
        var lastError = null;
        var iterate = function (i, err) {
            if (i === void 0) { i = 0; }
            if (err) {
                err.prev = lastError;
                lastError = err;
            }
            // Already tried all file systems, return the last error.
            if (i >= _this.fss.length) {
                // last one
                if (cb)
                    cb(err || Error('No file systems attached.'));
                return;
            }
            // Replace `callback` with our intermediate function.
            args[lastarg] = function (err) {
                if (err)
                    return iterate(i + 1, err);
                if (cb)
                    cb.apply(cb, arguments);
            };
            var j = _this.fss.length - i - 1;
            var fs = _this.fss[j];
            var func = fs[method];
            if (!func)
                iterate(i + 1, Error('Method not supported: ' + method));
            else
                func.apply(fs, args);
        };
        iterate();
    };
    Union.prototype.promiseMethod = function (method, args) {
        return __awaiter(this, void 0, void 0, function () {
            var lastError, i, theFs, promises, err_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        lastError = null;
                        i = this.fss.length - 1;
                        _a.label = 1;
                    case 1:
                        if (!(i >= 0)) return [3 /*break*/, 6];
                        theFs = this.fss[i];
                        promises = theFs.promises;
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        if (!promises || !promises[method]) {
                            throw Error("Promise of method not supported: \"".concat(String(method), "\" with args \"").concat(args, "\""));
                        }
                        return [4 /*yield*/, promises[method].apply(promises, args)];
                    case 3: 
                    // return promises[method](...args);
                    return [2 /*return*/, _a.sent()];
                    case 4:
                        err_2 = _a.sent();
                        err_2.prev = lastError;
                        lastError = err_2;
                        if (!i) {
                            // last one
                            throw err_2;
                        }
                        else {
                            // Ignore error...
                            // continue;
                        }
                        return [3 /*break*/, 5];
                    case 5:
                        i--;
                        return [3 /*break*/, 1];
                    case 6: return [2 /*return*/];
                }
            });
        });
    };
    return Union;
}());
exports.Union = Union;
