"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useTimeSelection;
var _timeUtil = require("../utils/timeUtil");
function useTimeSelection(_ref) {
  var value = _ref.value,
    generateConfig = _ref.generateConfig,
    disabledMinutes = _ref.disabledMinutes,
    disabledSeconds = _ref.disabledSeconds,
    minutes = _ref.minutes,
    seconds = _ref.seconds,
    use12Hours = _ref.use12Hours;
  var setTime = function setTime(isNewPM, newHour, newMinute, newSecond) {
    var now = generateConfig.getNow();
    var newDate = value || now;
    var newFormattedHour = !use12Hours || !isNewPM ? newHour : newHour + 12;
    var mergedHour = newHour < 0 ? generateConfig.getHour(now) : newFormattedHour;
    var mergedMinute = newMinute < 0 ? generateConfig.getMinute(now) : newMinute;
    var mergedSecond = newSecond < 0 ? generateConfig.getSecond(now) : newSecond;
    var newDisabledMinutes = disabledMinutes && disabledMinutes(mergedHour);
    if (newDisabledMinutes !== null && newDisabledMinutes !== void 0 && newDisabledMinutes.includes(mergedMinute)) {
      // find the first available minute in minutes
      var availableMinute = minutes.find(function (i) {
        return !newDisabledMinutes.includes(i.value);
      });
      if (availableMinute) {
        mergedMinute = availableMinute.value;
      } else {
        return null;
      }
    }
    var newDisabledSeconds = disabledSeconds && disabledSeconds(mergedHour, mergedMinute);
    if (newDisabledSeconds !== null && newDisabledSeconds !== void 0 && newDisabledSeconds.includes(mergedSecond)) {
      // find the first available second in seconds
      var availableSecond = seconds.find(function (i) {
        return !newDisabledSeconds.includes(i.value);
      });
      if (availableSecond) {
        mergedSecond = availableSecond.value;
      } else {
        return null;
      }
    }
    newDate = (0, _timeUtil.setTime)(generateConfig, newDate, mergedHour, mergedMinute, mergedSecond);
    return newDate;
  };
  return setTime;
}