"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.utf8Count = void 0;
function utf8Count(str) {
    const strLength = str.length;
    let byteLength = 0;
    let pos = 0;
    while (pos < strLength) {
        let value = str.charCodeAt(pos++);
        if ((value & 0xffffff80) === 0) {
            byteLength++;
            continue;
        }
        else if ((value & 0xfffff800) === 0) {
            byteLength += 2;
        }
        else {
            if (value >= 0xd800 && value <= 0xdbff) {
                if (pos < strLength) {
                    const extra = str.charCodeAt(pos);
                    if ((extra & 0xfc00) === 0xdc00) {
                        ++pos;
                        value = ((value & 0x3ff) << 10) + (extra & 0x3ff) + 0x10000;
                    }
                }
            }
            if ((value & 0xffff0000) === 0) {
                byteLength += 3;
            }
            else {
                byteLength += 4;
            }
        }
    }
    return byteLength;
}
exports.utf8Count = utf8Count;
