"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcErrorType = void 0;
const json_type_1 = require("../../../../../json-type");
exports.RpcErrorType = json_type_1.t
    .Object(json_type_1.t.prop('message', json_type_1.t.str).options({
    title: 'Error message',
    description: 'A human-readable error message.',
}), json_type_1.t.propOpt('code', json_type_1.t.str.options({ ascii: true })).options({
    title: 'Error code',
    description: 'A machine-readable fixed error code tag.',
}), json_type_1.t.propOpt('errno', json_type_1.t.num).options({
    title: 'Error number',
    description: 'A machine-readable fixed error code number. Same as "code" but in numeric form.',
}), json_type_1.t.propOpt('errorId', json_type_1.t.str.options({ ascii: true })).options({
    title: 'Error ID',
    description: 'Unique ID of the error as it is stored the system. Can be referenced to later to retrieve from storage.',
}), json_type_1.t.propOpt('meta', json_type_1.t.any).options({
    title: 'Error metadata',
    description: 'Additional extra metadata.',
}))
    .options({
    title: 'RPC Error',
    encodeUnknownFields: false,
});
