"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeRouterCaller = void 0;
const tslib_1 = require("tslib");
const error_1 = require("./error");
const RpcCaller_1 = require("./RpcCaller");
const classes_1 = require("../../../../json-type/type/classes");
const StaticRpcMethod_1 = require("../methods/StaticRpcMethod");
const StreamingRpcMethod_1 = require("../methods/StreamingRpcMethod");
class TypeRouterCaller extends RpcCaller_1.RpcCaller {
    constructor(_a) {
        var { router } = _a, rest = tslib_1.__rest(_a, ["router"]);
        super(Object.assign(Object.assign({}, rest), { getMethod: (name) => this.get(name) }));
        this.methods = new Map();
        this.req = null;
        this.res = null;
        this.router = router;
        this.system = router.system;
    }
    get(id) {
        let method = this.methods.get(id);
        if (method)
            return method;
        const fn = this.router.routes[id];
        if (!fn || !(fn instanceof classes_1.FunctionType || fn instanceof classes_1.FunctionStreamingType))
            throw error_1.RpcError.valueFromCode(error_1.RpcErrorCodes.METHOD_NOT_FOUND, `Type [alias = ${id}] is not a function.`);
        const validator = fn.req.validator('object');
        const requestSchema = fn.req.getSchema();
        const isRequestVoid = requestSchema.__t === 'const' && requestSchema.value === undefined;
        const validate = isRequestVoid
            ? () => { }
            : (req) => {
                const error = validator(req);
                if (error) {
                    throw error_1.RpcError.value(error_1.RpcError.validation(error.message, error));
                }
            };
        method =
            fn instanceof classes_1.FunctionType
                ? new StaticRpcMethod_1.StaticRpcMethod({
                    req: fn.req,
                    res: fn.res,
                    validate,
                    call: fn.singleton,
                })
                : new StreamingRpcMethod_1.StreamingRpcMethod({
                    req: fn.req,
                    res: fn.res,
                    validate,
                    call$: fn.singleton,
                });
        this.methods.set(id, method);
        return method;
    }
    call(id, request, ctx) {
        const _super = Object.create(null, {
            call: { get: () => super.call }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return _super.call.call(this, id, request, ctx);
        });
    }
}
exports.TypeRouterCaller = TypeRouterCaller;
