"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Value = void 0;
class Value {
    constructor(data, type) {
        this.data = data;
        this.type = type;
    }
    encode(codec) {
        const value = this.data;
        const type = this.type;
        if (value === undefined)
            return;
        const encoder = codec.encoder;
        if (!type)
            encoder.writeAny(value);
        else
            type.encoder(codec.format)(value, encoder);
    }
}
exports.Value = Value;
