"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const uWebSockets_js_1 = require("uWebSockets.js");
const sample_api_1 = require("../common/rpc/__tests__/sample-api");
const RpcApp_1 = require("../server/uws/RpcApp");
const Codecs_1 = require("../../json-pack/codecs/Codecs");
const Writer_1 = require("../../util/buffers/Writer");
const uws = (0, uWebSockets_js_1.App)({});
const caller = (0, sample_api_1.createCaller)();
const codecs = new Codecs_1.Codecs(new Writer_1.Writer());
const app = new RpcApp_1.RpcApp({
    uws,
    caller,
    codecs,
    maxRequestBodySize: 1024 * 1024,
});
app.enableCors();
app.enableHttpPing();
app.route('POST', '/echo', (ctx) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const json = yield ctx.requestBodyJson(1024);
    return json;
}));
app.enableHttpRpc();
app.enableWsRpc();
app.startRouting();
const port = +(process.env.PORT || 9999);
uws.listen(port, (token) => {
    if (token) {
        console.log({ msg: 'SERVER_STARTED', url: `http://localhost:${port}` });
    }
    else {
        console.error(`Failed to listen on ${port} port.`);
    }
});
