export interface TsModuleDeclaration {
    node: 'ModuleDeclaration';
    name: string;
    statements: TsDeclaration[];
    comment?: string;
}
export interface TsInterfaceDeclaration {
    node: 'InterfaceDeclaration';
    name: string;
    members: Array<TsPropertySignature | TsIndexSignature>;
    comment?: string;
}
export interface TsPropertySignature {
    node: 'PropertySignature';
    name: string;
    type: TsType;
    optional?: boolean;
    comment?: string;
}
export interface TsIndexSignature {
    node: 'IndexSignature';
    type: TsType;
}
export interface TsTypeAliasDeclaration {
    node: 'TypeAliasDeclaration';
    name: string;
    type: TsType;
    comment?: string;
}
export type TsDeclaration = TsModuleDeclaration | TsInterfaceDeclaration | TsTypeAliasDeclaration;
export interface TsArrayType {
    node: 'ArrayType';
    elementType: TsType;
}
export interface TsTupleType {
    node: 'TupleType';
    elements: TsType[];
}
export interface TsStringKeyword {
    node: 'StringKeyword';
}
export interface TsNumberKeyword {
    node: 'NumberKeyword';
}
export interface TsBooleanKeyword {
    node: 'BooleanKeyword';
}
export interface TsNullKeyword {
    node: 'NullKeyword';
}
export interface TsAnyKeyword {
    node: 'AnyKeyword';
}
export interface TsObjectKeyword {
    node: 'ObjectKeyword';
}
export interface TsUnknownKeyword {
    node: 'UnknownKeyword';
}
export interface TsTypeLiteral {
    node: 'TypeLiteral';
    members: Array<TsPropertySignature | TsIndexSignature>;
    comment?: string;
}
export interface TsStringLiteral {
    node: 'StringLiteral';
    text: string;
}
export interface TsNumericLiteral {
    node: 'NumericLiteral';
    text: string;
}
export interface TsTrueKeyword {
    node: 'TrueKeyword';
}
export interface TsFalseKeyword {
    node: 'FalseKeyword';
}
export interface TsUnionType {
    node: 'UnionType';
    types: TsType[];
}
export interface TsIdentifier {
    node: 'Identifier';
    name: string;
}
export interface TsGenericTypeAnnotation {
    node: 'GenericTypeAnnotation';
    id: TsIdentifier;
}
export interface TsTypeReference {
    node: 'TypeReference';
    typeName: string;
}
export type TsType = TsArrayType | TsTupleType | TsStringKeyword | TsNumberKeyword | TsBooleanKeyword | TsNullKeyword | TsObjectKeyword | TsAnyKeyword | TsTypeLiteral | TsStringLiteral | TsNumericLiteral | TsTrueKeyword | TsFalseKeyword | TsUnknownKeyword | TsUnionType | TsTypeReference | TsGenericTypeAnnotation;
export type TsNode = TsDeclaration | TsType | TsPropertySignature | TsIndexSignature;
