import * as classes from '../type/classes';
import { TypeSystem } from './TypeSystem';
import type { TypeBuilder } from '../type/TypeBuilder';
export interface TypeRouterOptions<R extends RoutesBase> {
    system: TypeSystem;
    routes: R;
}
export declare class TypeRouter<Routes extends RoutesBase> {
    static create: <NewRoutes extends RoutesBase>(routes?: ((t: TypeRouter<{}>) => NewRoutes) | undefined) => TypeRouter<NewRoutes>;
    system: TypeSystem;
    t: TypeBuilder;
    routes: Routes;
    constructor(options: TypeRouterOptions<Routes>);
    protected merge<Router extends TypeRouter<any>>(router: Router): TypeRouter<Routes & TypeRouterRoutes<Router>>;
    extend<NewRoutes extends RoutesBase>(routes: (t: this) => NewRoutes): TypeRouter<Routes & NewRoutes>;
}
export type RoutesBase = Record<string, classes.FunctionType<any, any>>;
type TypeRouterRoutes<R extends TypeRouter<any>> = R extends TypeRouter<infer R2> ? R2 : never;
export {};
