"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliCodecJson4 = void 0;
const JsonDecoder_1 = require("../../json-pack/json/JsonDecoder");
const JsonEncoder_1 = require("../../json-pack/json/JsonEncoder");
const bufferToUint8Array_1 = require("../../util/buffers/bufferToUint8Array");
class CliCodecJson4 {
    constructor(writer) {
        this.writer = writer;
        this.id = 'json4';
        this.description = 'JSON codec with 4 space pretty-printing';
        this.encoder = new JsonEncoder_1.JsonEncoder(writer);
        this.decoder = new JsonDecoder_1.JsonDecoder();
    }
    encode(value) {
        const uint8 = this.encoder.encode(value);
        const pojo = JSON.parse(Buffer.from(uint8).toString('utf8'));
        const json = JSON.stringify(pojo, null, 4) + '\n';
        return (0, bufferToUint8Array_1.bufferToUint8Array)(Buffer.from(json, 'utf8'));
    }
    decode(bytes) {
        return this.decoder.read(bytes);
    }
}
exports.CliCodecJson4 = CliCodecJson4;
