import { JsonDecoder } from '../../json-pack/json/JsonDecoder';
import { JsonEncoder } from '../../json-pack/json/JsonEncoder';
import type { Writer } from '../../util/buffers/Writer';
import type { CliCodec } from '../types';
export declare class CliCodecJson2 implements CliCodec<'json2'> {
    protected readonly writer: Writer;
    readonly id = "json2";
    readonly description = "JSON codec with 2 space pretty-printing";
    protected readonly encoder: JsonEncoder;
    protected readonly decoder: JsonDecoder;
    constructor(writer: Writer);
    encode(value: unknown): Uint8Array;
    decode(bytes: Uint8Array): unknown;
}
