import { CborDecoder } from '../../json-pack/cbor/CborDecoder';
import { CborEncoder } from '../../json-pack/cbor/CborEncoder';
import type { Writer } from '../../util/buffers/Writer';
import type { CliCodec } from '../types';
export declare class CliCodecCbor implements CliCodec<'cbor'> {
    protected readonly writer: Writer;
    readonly id = "cbor";
    readonly description = "CBOR codec";
    protected readonly encoder: CborEncoder;
    protected readonly decoder: CborDecoder;
    constructor(writer: Writer);
    encode(value: unknown): Uint8Array;
    decode(bytes: Uint8Array): unknown;
}
