"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isInteger = exports.isValidIndex = exports.parent = exports.isRoot = exports.isPathEqual = exports.isChild = exports.toPath = exports.formatJsonPointer = exports.parseJsonPointer = exports.escapeComponent = exports.unescapeComponent = void 0;
const r1 = /~1/g;
const r2 = /~0/g;
const r3 = /~/g;
const r4 = /\//g;
function unescapeComponent(component) {
    if (component.indexOf('~') === -1)
        return component;
    return component.replace(r1, '/').replace(r2, '~');
}
exports.unescapeComponent = unescapeComponent;
function escapeComponent(component) {
    if (component.indexOf('/') === -1 && component.indexOf('~') === -1)
        return component;
    return component.replace(r3, '~0').replace(r4, '~1');
}
exports.escapeComponent = escapeComponent;
function parseJsonPointer(pointer) {
    if (!pointer)
        return [];
    return pointer.slice(1).split('/').map(unescapeComponent);
}
exports.parseJsonPointer = parseJsonPointer;
function formatJsonPointer(path) {
    if ((0, exports.isRoot)(path))
        return '';
    return '/' + path.map((component) => escapeComponent(String(component))).join('/');
}
exports.formatJsonPointer = formatJsonPointer;
const toPath = (pointer) => (typeof pointer === 'string' ? parseJsonPointer(pointer) : pointer);
exports.toPath = toPath;
function isChild(parent, child) {
    if (parent.length >= child.length)
        return false;
    for (let i = 0; i < parent.length; i++)
        if (parent[i] !== child[i])
            return false;
    return true;
}
exports.isChild = isChild;
function isPathEqual(p1, p2) {
    if (p1.length !== p2.length)
        return false;
    for (let i = 0; i < p1.length; i++)
        if (p1[i] !== p2[i])
            return false;
    return true;
}
exports.isPathEqual = isPathEqual;
const isRoot = (path) => !path.length;
exports.isRoot = isRoot;
function parent(path) {
    if (path.length < 1)
        throw new Error('NO_PARENT');
    return path.slice(0, path.length - 1);
}
exports.parent = parent;
function isValidIndex(index) {
    if (typeof index === 'number')
        return true;
    const n = parseInt(index, 10);
    return String(n) === index && n >= 0;
}
exports.isValidIndex = isValidIndex;
const isInteger = (str) => {
    const len = str.length;
    let i = 0;
    let charCode;
    while (i < len) {
        charCode = str.charCodeAt(i);
        if (charCode >= 48 && charCode <= 57) {
            i++;
            continue;
        }
        return false;
    }
    return true;
};
exports.isInteger = isInteger;
