"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpMove = void 0;
const AbstractOp_1 = require("./AbstractOp");
const OpRemove_1 = require("./OpRemove");
const OpAdd_1 = require("./OpAdd");
const json_pointer_1 = require("../../json-pointer");
class OpMove extends AbstractOp_1.AbstractOp {
    constructor(path, from) {
        super(path);
        this.from = from;
    }
    op() {
        return 'move';
    }
    code() {
        return 4;
    }
    apply(doc) {
        const remove = new OpRemove_1.OpRemove((0, json_pointer_1.toPath)(this.from), undefined).apply(doc);
        const add = new OpAdd_1.OpAdd(this.path, remove.old).apply(remove.doc);
        return add;
    }
    toJson(parent) {
        return {
            op: 'move',
            path: (0, json_pointer_1.formatJsonPointer)(this.path),
            from: (0, json_pointer_1.formatJsonPointer)(this.from),
        };
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'move' : 4;
        return [opcode, this.path, this.from];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(4);
        encoder.encodeArray(this.path);
        encoder.encodeArray(this.from);
    }
}
exports.OpMove = OpMove;
