"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpFlip = void 0;
const AbstractOp_1 = require("./AbstractOp");
const json_pointer_1 = require("../../json-pointer");
class OpFlip extends AbstractOp_1.AbstractOp {
    constructor(path) {
        super(path);
    }
    op() {
        return 'flip';
    }
    code() {
        return 8;
    }
    apply(doc) {
        const ref = (0, json_pointer_1.find)(doc, this.path);
        if (ref.obj)
            ref.obj[ref.key] = !ref.val;
        else
            doc = !ref.val;
        return { doc, old: ref.val };
    }
    toJson(parent) {
        const op = {
            op: 'flip',
            path: (0, json_pointer_1.formatJsonPointer)(this.path),
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'flip' : 8;
        return [opcode, this.path];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(2);
        encoder.writer.u8(8);
        encoder.encodeArray(this.path);
    }
}
exports.OpFlip = OpFlip;
