"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpCopy = void 0;
const AbstractOp_1 = require("./AbstractOp");
const json_pointer_1 = require("../../json-pointer");
const OpAdd_1 = require("./OpAdd");
const clone_1 = require("../../json-clone/clone");
class OpCopy extends AbstractOp_1.AbstractOp {
    constructor(path, from) {
        super(path);
        this.from = from;
    }
    op() {
        return 'copy';
    }
    code() {
        return 3;
    }
    apply(doc) {
        const { val } = (0, json_pointer_1.find)(doc, this.from);
        if (val === undefined)
            throw new Error('NOT_FOUND');
        const add = new OpAdd_1.OpAdd(this.path, (0, clone_1.clone)(val)).apply(doc);
        return add;
    }
    toJson(parent) {
        return {
            op: 'copy',
            path: (0, json_pointer_1.formatJsonPointer)(this.path),
            from: (0, json_pointer_1.formatJsonPointer)(this.from),
        };
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'copy' : 3;
        return [opcode, this.path, this.from];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(3);
        encoder.encodeArray(this.path);
        encoder.encodeArray(this.from);
    }
}
exports.OpCopy = OpCopy;
