"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.$add = exports.$$add = void 0;
const codegen_1 = require("../../../util/codegen");
const findRef_1 = require("../../../json-pointer/codegen/findRef");
const $$add = (op) => {
    const find = (0, findRef_1.$findRef)(op.path);
    const js = `
(function(find, path){
  return function(doc){
    var value = ${JSON.stringify(op.value)};
    var f = find(doc);
    var obj = f.obj, key = f.key, val = f.val;
    if (!obj) doc = value;
    else if (typeof key === 'string') obj[key] = value;
    else {
      var length = obj.length;
      if (key < length) obj.splice(key, 0, value);
      else if (key > length) throw new Error('INVALID_INDEX');
      else obj.push(value);
    }
    return doc;
  };
})`;
    return {
        deps: [find, op.path],
        js: js,
    };
};
exports.$$add = $$add;
const $add = (op) => (0, codegen_1.compileClosure)((0, exports.$$add)(op));
exports.$add = $add;
