"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyPatch = exports.applyOps = exports.applyOp = void 0;
const clone_1 = require("../../json-clone/clone");
const json_1 = require("../codec/json");
function applyOp(doc, op, mutate) {
    if (!mutate)
        doc = (0, clone_1.clone)(doc);
    return op.apply(doc);
}
exports.applyOp = applyOp;
function applyOps(doc, ops, mutate) {
    if (!mutate)
        doc = (0, clone_1.clone)(doc);
    const res = [];
    const length = ops.length;
    for (let i = 0; i < length; i++) {
        const opResult = ops[i].apply(doc);
        doc = opResult.doc;
        res.push(opResult);
    }
    return { doc, res };
}
exports.applyOps = applyOps;
function applyPatch(doc, patch, options) {
    if (!options.mutate)
        doc = (0, clone_1.clone)(doc);
    const res = [];
    const length = patch.length;
    for (let i = 0; i < length; i++) {
        const op = (0, json_1.operationToOp)(patch[i], options);
        const opResult = op.apply(doc);
        doc = opResult.doc;
        res.push(opResult);
    }
    return { doc, res };
}
exports.applyPatch = applyPatch;
