"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lowerArrayPath = exports.bumpArrayPath = void 0;
const json_pointer_1 = require("../../json-pointer");
const bumpArrayPath = (path1, path2) => {
    const folder = (0, json_pointer_1.parent)(path1);
    const lastIndex = path1.length - 1;
    const step1 = path1[lastIndex];
    if ((0, json_pointer_1.isChild)(folder, path2)) {
        const step2 = path2[lastIndex];
        if ((0, json_pointer_1.isValidIndex)(step2)) {
            const index1 = Number(step1);
            const index2 = Number(step2);
            if (index1 <= index2) {
                const steps = [...path2];
                steps[lastIndex] = String(index2 + 1);
                return steps;
            }
        }
    }
    return undefined;
};
exports.bumpArrayPath = bumpArrayPath;
const lowerArrayPath = (path1, path2) => {
    const folder = (0, json_pointer_1.parent)(path1);
    const lastIndex = path1.length - 1;
    const step1 = path1[lastIndex];
    if ((0, json_pointer_1.isChild)(folder, path2)) {
        const step2 = path2[lastIndex];
        if ((0, json_pointer_1.isValidIndex)(step2)) {
            const index1 = Number(step1);
            const index2 = Number(step2);
            if (index1 < index2) {
                const steps = [...path2];
                steps[lastIndex] = String(index2 - 1);
                return steps;
            }
        }
    }
    return undefined;
};
exports.lowerArrayPath = lowerArrayPath;
