import type { IWriter, IWriterGrowable } from '../../util/buffers';
import type { BinaryJsonEncoder, StreamingBinaryJsonEncoder, TlvBinaryJsonEncoder } from '../types';
import type { Slice } from '../../util/buffers/Slice';
export declare class CborEncoderFast<W extends IWriter & IWriterGrowable = IWriter & IWriterGrowable> implements BinaryJsonEncoder, StreamingBinaryJsonEncoder, TlvBinaryJsonEncoder {
    readonly writer: W;
    constructor(writer?: W);
    encode(value: unknown): Uint8Array;
    encodeToSlice(value: unknown): Slice;
    writeAny(value: unknown): void;
    writeCbor(): void;
    writeEnd(): void;
    writeNull(): void;
    writeBoolean(bool: boolean): void;
    writeNumber(num: number): void;
    writeInteger(int: number): void;
    writeUInteger(uint: number): void;
    encodeNumber(num: number): void;
    encodeInteger(int: number): void;
    encodeUint(uint: number): void;
    encodeNint(int: number): void;
    writeFloat(float: number): void;
    writeBin(buf: Uint8Array): void;
    writeBinHdr(length: number): void;
    writeStartBin(): void;
    writeStr(str: string): void;
    writeStrHdr(length: number): void;
    writeAsciiStr(str: string): void;
    writeStartStr(): void;
    writeArr(arr: unknown[]): void;
    writeArrHdr(length: number): void;
    writeStartArr(): void;
    writeEndArr(): void;
    writeObj(obj: Record<string, unknown>): void;
    writeObjHdr(length: number): void;
    writeMapHdr(length: number): void;
    writeStartMap(): void;
    writeStartObj(): void;
    writeEndObj(): void;
    writeTag(tag: number, value: unknown): void;
    writeTagHdr(tag: number): void;
    writeTkn(value: number): void;
}
