"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validate = void 0;
const validate = (op) => {
    if (!(op instanceof Array))
        return 1;
    if (op.length === 0)
        return 1;
    let last;
    for (let i = 0; i < op.length; i++) {
        const component = op[i];
        switch (typeof component) {
            case 'number': {
                if (!component)
                    return 2;
                if (component !== Math.round(component))
                    return 2;
                if (component > 0) {
                    const lastComponentIsRetain = typeof last === 'number' && last > 0;
                    if (lastComponentIsRetain)
                        return 3;
                }
                else {
                    const lastComponentIsDelete = typeof last === 'number' && last < 0;
                    if (lastComponentIsDelete)
                        return 3;
                }
                break;
            }
            case 'string': {
                if (!component.length)
                    return 2;
                const lastComponentIsInsert = typeof last === 'string';
                if (lastComponentIsInsert)
                    return 3;
                break;
            }
            case 'object': {
                if (!(component instanceof Array))
                    return 2;
                if (component.length !== 1)
                    return 2;
                const lastComponentIsRetainedDelete = last instanceof Array;
                if (lastComponentIsRetainedDelete)
                    return 3;
                break;
            }
            default:
                return 2;
        }
        last = component;
    }
    const isLastRetain = typeof last === 'number' && last > 0;
    if (isLastRetain)
        return 4;
    return 0;
};
exports.validate = validate;
