"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const quill_delta_1 = tslib_1.__importDefault(require("quill-delta"));
const delta = new quill_delta_1.default([
    { insert: 'Gandalf', attributes: { bold: true } },
    { insert: ' the ' },
    { insert: 'Grey', attributes: { color: '#ccc' } },
]);
console.log(delta.ops.reduce((str, op) => str + (op.insert || ''), ''));
console.log(delta.ops);
const death = new quill_delta_1.default().retain(12).insert('White', { color: '#fff' }).delete(4);
console.log(death.ops.reduce((str, op) => str + (op.insert || ''), ''));
console.log(death.ops);
const result = delta.compose(death);
console.log(result.ops.reduce((str, op) => str + (op.insert || ''), ''));
console.log(result.ops);
const embed = new quill_delta_1.default([
    { retain: 2 },
    {
        insert: {
            image: 'https://quilljs.com/assets/images/icon.png',
        },
        attributes: {
            link: 'https://quilljs.com',
        },
    },
]);
const result2 = result.compose(embed);
console.log(result2.ops);
