"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.comparisonOperators = void 0;
const tslib_1 = require("tslib");
const codegen_steps_1 = require("../codegen-steps");
const deepEqual_1 = require("../../json-equal/deepEqual");
const __deepEqual_1 = require("../../json-equal/$$deepEqual");
const util = tslib_1.__importStar(require("../util"));
const eqLitVsExpr = (literal, expression, ctx, not) => {
    const fn = (0, __deepEqual_1.$$deepEqual)(literal.val);
    const d = ctx.const(fn);
    return new codegen_steps_1.Expression(`${not ? '!' : ''}${d}(${expression})`);
};
const binaryOperands = (expr, ctx) => {
    const left = ctx.eval(expr[1], ctx);
    const right = ctx.eval(expr[2], ctx);
    return [left, right];
};
const ternaryOperands = (expr, ctx) => {
    const a = ctx.eval(expr[1], ctx);
    const b = ctx.eval(expr[2], ctx);
    const c = ctx.eval(expr[3], ctx);
    return [a, b, c];
};
exports.comparisonOperators = [
    [
        '==',
        ['eq'],
        2,
        (expr, ctx) => {
            const [left, right] = binaryOperands(expr, ctx);
            return (0, deepEqual_1.deepEqual)(left, right);
        },
        (ctx) => {
            const a = ctx.operands[0];
            const b = ctx.operands[1];
            if (a instanceof codegen_steps_1.Literal && b instanceof codegen_steps_1.Expression)
                return eqLitVsExpr(a, b, ctx);
            if (b instanceof codegen_steps_1.Literal && a instanceof codegen_steps_1.Expression)
                return eqLitVsExpr(b, a, ctx);
            ctx.link(deepEqual_1.deepEqual, 'deepEqual');
            return new codegen_steps_1.Expression(`deepEqual(${a},${b})`);
        },
    ],
    [
        '!=',
        ['ne'],
        2,
        (expr, ctx) => {
            const [left, right] = binaryOperands(expr, ctx);
            return !(0, deepEqual_1.deepEqual)(left, right);
        },
        (ctx) => {
            const a = ctx.operands[0];
            const b = ctx.operands[1];
            if (a instanceof codegen_steps_1.Literal && b instanceof codegen_steps_1.Expression)
                return eqLitVsExpr(a, b, ctx, true);
            if (b instanceof codegen_steps_1.Literal && a instanceof codegen_steps_1.Expression)
                return eqLitVsExpr(b, a, ctx, true);
            ctx.link(deepEqual_1.deepEqual, 'deepEqual');
            return new codegen_steps_1.Expression(`!deepEqual(${a},${b})`);
        },
    ],
    [
        '>',
        ['gt'],
        2,
        (expr, ctx) => {
            const [left, right] = binaryOperands(expr, ctx);
            return left > right;
        },
        (ctx) => {
            return new codegen_steps_1.Expression(`(${ctx.operands[0]})>(${ctx.operands[1]})`);
        },
    ],
    [
        '>=',
        ['ge'],
        2,
        (expr, ctx) => {
            const [left, right] = binaryOperands(expr, ctx);
            return left >= right;
        },
        (ctx) => {
            return new codegen_steps_1.Expression(`(${ctx.operands[0]})>=(${ctx.operands[1]})`);
        },
    ],
    [
        '<',
        ['lt'],
        2,
        (expr, ctx) => {
            const [left, right] = binaryOperands(expr, ctx);
            return left < right;
        },
        (ctx) => {
            return new codegen_steps_1.Expression(`(${ctx.operands[0]})<(${ctx.operands[1]})`);
        },
    ],
    [
        '<=',
        ['le'],
        2,
        (expr, ctx) => {
            const [left, right] = binaryOperands(expr, ctx);
            return left <= right;
        },
        (ctx) => {
            return new codegen_steps_1.Expression(`(${ctx.operands[0]})<=(${ctx.operands[1]})`);
        },
    ],
    [
        'cmp',
        [],
        2,
        (expr, ctx) => {
            const [left, right] = binaryOperands(expr, ctx);
            return util.cmp(left, right);
        },
        (ctx) => {
            ctx.link(util.cmp, 'cmp');
            return new codegen_steps_1.Expression(`cmp((${ctx.operands[0]}),(${ctx.operands[1]}))`);
        },
    ],
    [
        '=><=',
        ['between'],
        3,
        (expr, ctx) => {
            const [val, min, max] = ternaryOperands(expr, ctx);
            return util.betweenEqEq(val, min, max);
        },
        (ctx) => {
            ctx.link(util.betweenEqEq, 'betweenEqEq');
            return new codegen_steps_1.Expression(`betweenEqEq(${ctx.operands[0]},${ctx.operands[1]},${ctx.operands[2]})`);
        },
    ],
    [
        '><',
        [],
        3,
        (expr, ctx) => {
            const [val, min, max] = ternaryOperands(expr, ctx);
            return util.betweenNeNe(val, min, max);
        },
        (ctx) => {
            ctx.link(util.betweenNeNe, 'betweenNeNe');
            return new codegen_steps_1.Expression(`betweenNeNe(${ctx.operands[0]},${ctx.operands[1]},${ctx.operands[2]})`);
        },
    ],
    [
        '=><',
        [],
        3,
        (expr, ctx) => {
            const [val, min, max] = ternaryOperands(expr, ctx);
            return util.betweenEqNe(val, min, max);
        },
        (ctx) => {
            ctx.link(util.betweenEqNe, 'betweenEqNe');
            return new codegen_steps_1.Expression(`betweenEqNe(${ctx.operands[0]},${ctx.operands[1]},${ctx.operands[2]})`);
        },
    ],
    [
        '><=',
        [],
        3,
        (expr, ctx) => {
            const [val, min, max] = ternaryOperands(expr, ctx);
            return util.betweenNeEq(val, min, max);
        },
        (ctx) => {
            ctx.link(util.betweenNeEq, 'betweenNeEq');
            return new codegen_steps_1.Expression(`betweenNeEq(${ctx.operands[0]},${ctx.operands[1]},${ctx.operands[2]})`);
        },
    ],
];
