"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartialEditFactory = void 0;
const ClockTable_1 = require("../../json-crdt-patch/codec/clock/ClockTable");
const PartialEdit_1 = require("./PartialEdit");
class PartialEditFactory {
    constructor(decoder, encoder) {
        this.decoder = decoder;
        this.encoder = encoder;
    }
    startPartialEdit(clockBlob) {
        const reader = this.decoder.dec.reader;
        reader.reset(clockBlob);
        const clockTable = ClockTable_1.ClockTable.decode(reader);
        const partialEdit = new PartialEdit_1.PartialEdit(this.decoder, this.encoder, clockTable);
        return partialEdit;
    }
}
exports.PartialEditFactory = PartialEditFactory;
