import { ITimestampStruct, ITimespanStruct } from '../../../json-crdt-patch/clock';
export interface Chunk<T> {
    id: ITimestampStruct;
    span: number;
    del: boolean;
    data: T | undefined;
    len: number;
    p: Chunk<T> | undefined;
    l: Chunk<T> | undefined;
    r: Chunk<T> | undefined;
    p2: Chunk<T> | undefined;
    l2: Chunk<T> | undefined;
    r2: Chunk<T> | undefined;
    s: Chunk<T> | undefined;
    merge(content: T): void;
    split(ticks: number): Chunk<T>;
    delete(): void;
    clone(): Chunk<T>;
}
export declare abstract class AbstractRga<T> {
    readonly id: ITimestampStruct;
    root: Chunk<T> | undefined;
    ids: Chunk<T> | undefined;
    count: number;
    abstract view(): unknown;
    protected abstract createChunk(id: ITimestampStruct, content: T | undefined): Chunk<T>;
    protected abstract onChange(): void;
    constructor(id: ITimestampStruct);
    ins(after: ITimestampStruct, id: ITimestampStruct, content: T): void;
    insAt(position: number, id: ITimestampStruct, content: T): ITimestampStruct | undefined;
    protected insAfterRoot(after: ITimestampStruct, id: ITimestampStruct, content: T): void;
    protected insAfterChunk(after: ITimestampStruct, chunk: Chunk<T>, chunkOffset: number, id: ITimestampStruct, content: T): void;
    delete(spans: ITimespanStruct[]): void;
    protected deleteSpan(span: ITimespanStruct): void;
    find(position: number): void | ITimestampStruct;
    findChunk(position: number): void | [chunk: Chunk<T>, offset: number];
    findInterval(position: number, length: number): ITimespanStruct[];
    findInterval2(from: ITimestampStruct, to: ITimestampStruct): ITimespanStruct[];
    range0(startChunk: Chunk<T> | undefined, from: ITimestampStruct, to: ITimestampStruct, callback: (chunk: Chunk<T>, off: number, len: number) => void): Chunk<T> | undefined;
    first(): Chunk<T> | undefined;
    last(): Chunk<T> | undefined;
    lastId(): ITimestampStruct | undefined;
    next(curr: Chunk<T>): Chunk<T> | undefined;
    length(): number;
    size(): number;
    pos(chunk: Chunk<T>): number;
    setRoot(chunk: Chunk<T>): void;
    insertBefore(chunk: Chunk<T>, before: Chunk<T>): void;
    insertAfter(chunk: Chunk<T>, after: Chunk<T>): void;
    protected insertAfterRef(chunk: Chunk<T>, ref: ITimestampStruct, left: Chunk<T>): void;
    protected mergeContent(chunk: Chunk<T>, content: T): void;
    protected insertInside(chunk: Chunk<T>, at: Chunk<T>, offset: number): void;
    protected split(chunk: Chunk<T>, ticks: number): Chunk<T>;
    protected mergeTombstones(ch1: Chunk<T>, ch2: Chunk<T>): boolean;
    protected mergeTombstones2(start: Chunk<T>, end: Chunk<T>): void;
    removeTombstones(): void;
    deleteChunk(chunk: Chunk<T>): void;
    insertId(chunk: Chunk<T>): void;
    insertIdFast(chunk: Chunk<T>): void;
    protected deleteId(chunk: Chunk<T>): void;
    findById(after: ITimestampStruct): undefined | Chunk<T>;
    splay(chunk: Chunk<T>): void;
    iterator(): () => Chunk<T> | undefined;
    ingest(size: number, next: () => Chunk<T>): void;
    private _ingest;
    protected toStringName(): string;
    toString(tab?: string): string;
    protected printChunk(tab: string, chunk: Chunk<T>): string;
    protected formatChunk(chunk: Chunk<T>): string;
}
