import * as nodes from '../../../nodes';
import { ITimestampStruct, VectorClock } from '../../../../json-crdt-patch/clock';
import { Model } from '../../../model';
import * as types from './types';
export declare class Decoder {
    decode({ time, root }: types.JsonCrdtVerboseDocument): Model;
    protected cClock(timestamps: types.JsonCrdtVerboseLogicalTimestamp[]): VectorClock;
    protected cTs(stamp: types.JsonCrdtVerboseTimestamp): ITimestampStruct;
    protected cRoot(doc: Model, { value }: types.JsonCrdtVerboseVal): void;
    protected cNode(doc: Model, node: types.JsonCrdtNode): nodes.JsonNode;
    protected cObj(doc: Model, node: types.JsonCrdtVerboseObj): nodes.ObjNode;
    protected cVec(doc: Model, node: types.JsonCrdtVerboseVec): nodes.VecNode;
    protected cArr(doc: Model, node: types.JsonCrdtVerboseArr): nodes.ArrNode;
    protected cStr(doc: Model, node: types.JsonCrdtVerboseStr): nodes.StrNode;
    protected cBin(doc: Model, node: types.JsonCrdtVerboseBin): nodes.BinNode;
    protected cVal(doc: Model, node: types.JsonCrdtVerboseVal): nodes.ValNode;
    protected cCon(doc: Model, node: types.JsonCrdtVerboseCon): nodes.ConNode;
}
