import * as nodes from '../../../nodes';
import { ClockEncoder } from '../../../../json-crdt-patch/codec/clock/ClockEncoder';
import { CrdtWriter } from '../../../../json-crdt-patch/util/binary/CrdtWriter';
import { ITimestampStruct } from '../../../../json-crdt-patch/clock';
import { CborEncoder } from '../../../../json-pack/cbor/CborEncoder';
import { CRDT_MAJOR_OVERLAY } from './constants';
import type { Model } from '../../../model';
export declare class Encoder extends CborEncoder<CrdtWriter> {
    protected clockEncoder: ClockEncoder;
    protected time: number;
    protected doc: Model;
    constructor(writer?: CrdtWriter);
    encode(doc: Model<any>): Uint8Array;
    encodeLogical(model: Model): void;
    encodeServer(model: Model): void;
    protected encodeClockTable(x0: number, x: number): void;
    protected readonly cTableEntry: (entry: {
        clock: ITimestampStruct;
    }) => void;
    protected readonly tsLogical: (ts: ITimestampStruct) => void;
    protected readonly tsServer: (ts: ITimestampStruct) => void;
    protected ts: (ts: ITimestampStruct) => void;
    protected cRoot(root: nodes.RootNode): void;
    protected writeTL(majorOverlay: CRDT_MAJOR_OVERLAY, length: number): void;
    protected cNode(node: nodes.JsonNode): void;
    protected cCon(node: nodes.ConNode): void;
    protected cVal(node: nodes.ValNode): void;
    protected cObj(node: nodes.ObjNode): void;
    protected readonly cKey: (val: ITimestampStruct, key: string) => void;
    protected cVec(node: nodes.VecNode): void;
    protected cStr(node: nodes.StrNode): void;
    protected cBin(node: nodes.BinNode): void;
    protected cArr(node: nodes.ArrNode): void;
}
