"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClockDecoder = void 0;
const clock_1 = require("../../clock");
class ClockDecoder {
    static fromArr(arr) {
        const decoder = new ClockDecoder(arr[0], arr[1]);
        const length = arr.length;
        for (let i = 2; i < length; i += 2)
            decoder.pushTuple(arr[i], arr[i + 1]);
        return decoder;
    }
    constructor(sid, time) {
        this.table = [];
        this.clock = new clock_1.VectorClock(sid, time + 1);
        this.table.push((0, clock_1.ts)(sid, time));
    }
    pushTuple(sid, time) {
        const id = (0, clock_1.ts)(sid, time);
        this.clock.observe(id, 1);
        this.table.push(id);
    }
    decodeId(sessionIndex, timeDiff) {
        if (!sessionIndex)
            return (0, clock_1.ts)(0, timeDiff);
        const clock = this.table[sessionIndex - 1];
        if (!clock)
            throw new Error('INVALID_CLOCK_TABLE');
        return (0, clock_1.ts)(clock.sid, clock.time - timeDiff);
    }
}
exports.ClockDecoder = ClockDecoder;
