"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.testSuites = void 0;
const tslib_1 = require("tslib");
const tests_json_1 = tslib_1.__importDefault(require("./tests.json"));
const op_add_tests_json_1 = tslib_1.__importDefault(require("./op.add.tests.json"));
const op_replace_tests_json_1 = tslib_1.__importDefault(require("./op.replace.tests.json"));
const op_remove_tests_json_1 = tslib_1.__importDefault(require("./op.remove.tests.json"));
const op_move_tests_json_1 = tslib_1.__importDefault(require("./op.move.tests.json"));
const op_copy_tests_json_1 = tslib_1.__importDefault(require("./op.copy.tests.json"));
const op_test_tests_json_1 = tslib_1.__importDefault(require("./op.test.tests.json"));
const op_str_ins_tests_json_1 = tslib_1.__importDefault(require("./op.str_ins.tests.json"));
const op_str_del_tests_json_1 = tslib_1.__importDefault(require("./op.str_del.tests.json"));
const op_flip_tests_json_1 = tslib_1.__importDefault(require("./op.flip.tests.json"));
const op_inc_tests_json_1 = tslib_1.__importDefault(require("./op.inc.tests.json"));
const op_split_tests_json_1 = tslib_1.__importDefault(require("./op.split.tests.json"));
const op_merge_tests_json_1 = tslib_1.__importDefault(require("./op.merge.tests.json"));
const op_extend_tests_json_1 = tslib_1.__importDefault(require("./op.extend.tests.json"));
const op_contains_tests_json_1 = tslib_1.__importDefault(require("./op.contains.tests.json"));
const op_defined_tests_json_1 = tslib_1.__importDefault(require("./op.defined.tests.json"));
const op_ends_tests_json_1 = tslib_1.__importDefault(require("./op.ends.tests.json"));
const op_in_tests_json_1 = tslib_1.__importDefault(require("./op.in.tests.json"));
const op_less_tests_json_1 = tslib_1.__importDefault(require("./op.less.tests.json"));
const op_more_tests_json_1 = tslib_1.__importDefault(require("./op.more.tests.json"));
const op_starts_tests_json_1 = tslib_1.__importDefault(require("./op.starts.tests.json"));
const op_type_tests_json_1 = tslib_1.__importDefault(require("./op.type.tests.json"));
const op_undefined_tests_json_1 = tslib_1.__importDefault(require("./op.undefined.tests.json"));
const spec_json_1 = tslib_1.__importDefault(require("./spec.json"));
exports.testSuites = [
    {
        name: 'JSON Patch spec',
        tests: spec_json_1.default,
        isJsonPatchSpec: true,
    },
    {
        name: 'JSON Patch smoke tests',
        tests: tests_json_1.default,
        isJsonPatchSpec: true,
    },
    {
        name: 'JSON Patch "add" operation',
        tests: op_add_tests_json_1.default,
        isJsonPatchSpec: true,
    },
    {
        name: 'JSON Patch "replace" operation',
        tests: op_replace_tests_json_1.default,
        isJsonPatchSpec: true,
    },
    {
        name: 'JSON Patch "remove" operation',
        tests: op_remove_tests_json_1.default,
        isJsonPatchSpec: true,
    },
    {
        name: 'JSON Patch "move" operation',
        tests: op_move_tests_json_1.default,
        isJsonPatchSpec: true,
    },
    {
        name: 'JSON Patch "copy" operation',
        tests: op_copy_tests_json_1.default,
        isJsonPatchSpec: true,
    },
    {
        name: 'JSON Patch "test" operation',
        tests: op_test_tests_json_1.default,
        isJsonPatchSpec: true,
    },
    {
        name: 'JSON Patch Extended "str_ins" operation',
        tests: op_str_ins_tests_json_1.default,
    },
    {
        name: 'JSON Patch Extended "str_del" operation',
        tests: op_str_del_tests_json_1.default,
    },
    {
        name: 'JSON Patch Extended "flip" operation',
        tests: op_flip_tests_json_1.default,
    },
    {
        name: 'JSON Patch Extended "inc" operation',
        tests: op_inc_tests_json_1.default,
    },
    {
        name: 'JSON Patch for Slate.js "split" operation',
        tests: op_split_tests_json_1.default,
    },
    {
        name: 'JSON Patch for Slate.js "merge" operation',
        tests: op_merge_tests_json_1.default,
    },
    {
        name: 'JSON Patch for Slate.js "extend" operation',
        tests: op_extend_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "contains" operation',
        tests: op_contains_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "defined" operation',
        tests: op_defined_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "ends" operation',
        tests: op_ends_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "in" operation',
        tests: op_in_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "less" operation',
        tests: op_less_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "more" operation',
        tests: op_more_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "starts" operation',
        tests: op_starts_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "type" operation',
        tests: op_type_tests_json_1.default,
    },
    {
        name: 'JSON Predicate "undefined" operation',
        tests: op_undefined_tests_json_1.default,
    },
];
