import { Printable } from '../print/types';
import { RadixTree } from '../trees/radix/RadixTree';
import { RouterCodegenCtx, RouterCodegenOpts } from './codegen';
import { Destination, Route } from './router';
import { ExactStep, RegexStep, UntilStep } from './steps';
export declare class RoutingTreeNode implements Printable {
    readonly exact: Map<number, [step: ExactStep, destination: Destination][]>;
    readonly start: RadixTree<RoutingTreeNode>;
    readonly until: [step: UntilStep, destination: RoutingTreeNode][];
    readonly regex: [step: RegexStep, destination: RoutingTreeNode | Destination][];
    end?: Destination;
    add(route: Route, step: number, destination: Destination): void;
    codegen(ctx: RouterCodegenCtx, opts: RouterCodegenOpts): void;
    toString(tab: string): string;
}
