import { Codegen } from '../codegen';
import { JsExpression } from '../codegen/util/JsExpression';
export class RouterCodegenCtx {
    codegen;
    constructor() {
        this.codegen = new Codegen({
            args: ['str'],
            prologue: 'str = "" + str; var len = str.length|0;',
            epilogue: 'return undefined;',
        });
    }
}
export class RouterCodegenOpts {
    slice;
    offset;
    depth;
    constructor(slice, offset, depth = 0) {
        this.slice = slice;
        this.offset = offset;
        this.depth = depth;
    }
    create(offset) {
        const slice = new JsExpression(() => `str.slice(${offset})`);
        return new RouterCodegenOpts(slice, offset, this.depth + 1);
    }
}
