export class JsExpression {
    expression;
    _wasUsed = false;
    _expression;
    _listeners = [];
    constructor(expression) {
        this.expression = expression;
    }
    get wasUsed() {
        return this._wasUsed;
    }
    use() {
        if (this._wasUsed)
            return this._expression;
        this._wasUsed = true;
        const expression = (this._expression = this.expression());
        for (const listener of this._listeners)
            listener(expression);
        return expression;
    }
    chain(use) {
        return new JsExpression(() => use(this.use()));
    }
    addListener(listener) {
        this._listeners.push(listener);
    }
}
