import { microtask } from './microtask';
export function subscribeCompleteObserver(observable, observer) {
    let completed = false;
    let completeCalled = false;
    let tasks = 0;
    return observable.subscribe({
        next: (value) => {
            tasks++;
            microtask(() => {
                tasks--;
                if (completed && !tasks) {
                    completeCalled = true;
                    observer.complete(value, true);
                }
                else {
                    observer.next(value);
                }
            });
        },
        error: (error) => {
            if (!tasks)
                observer.error(error);
            else
                microtask(() => {
                    observer.error(error);
                });
        },
        complete: () => {
            completed = true;
            if (completeCalled)
                return;
            if (!tasks)
                observer.complete(undefined, false);
            else {
                microtask(() => {
                    if (completeCalled)
                        return;
                    observer.complete(undefined, false);
                });
            }
        },
    });
}
