export class TimedQueue {
    itemLimit = 100;
    timeLimit = 5;
    onFlush = (list) => { };
    list = [];
    timer = null;
    push(item) {
        this.list.push(item);
        if (this.list.length >= this.itemLimit) {
            this.flush();
            return;
        }
        if (!this.timer) {
            this.timer = setTimeout(() => {
                this.flush();
            }, this.timeLimit);
        }
    }
    flush() {
        const list = this.list;
        this.list = [];
        if (this.timer)
            clearTimeout(this.timer);
        this.timer = null;
        if (list.length)
            this.onFlush(list);
        return list;
    }
}
