import type { IRpcMethodBase, IStreamingRpcMethod } from './types';
export interface StreamingRpcMethodOptions<Ctx = unknown, Req = unknown, Res = unknown> extends Omit<IStreamingRpcMethod<Ctx, Req, Res>, 'isStreaming' | 'call'> {
}
export declare class StreamingRpcMethod<Ctx = unknown, Req = unknown, Res = unknown> implements IStreamingRpcMethod<Ctx, Req, Res> {
    readonly isStreaming = true;
    readonly pretty: boolean;
    readonly validate?: IStreamingRpcMethod<Ctx, Req, Res>['validate'];
    readonly onPreCall?: (ctx: Ctx, request: Req) => Promise<void>;
    readonly req?: IStreamingRpcMethod<Ctx, Req, Res>['req'];
    readonly res?: IStreamingRpcMethod<Ctx, Req, Res>['res'];
    readonly call: IRpcMethodBase<Ctx, Req, Res>['call'];
    readonly call$: IRpcMethodBase<Ctx, Req, Res>['call$'];
    readonly preCallBufferSize?: number;
    constructor(options: StreamingRpcMethodOptions<Ctx, Req, Res>);
}
