import * as msg from '../../messages';
import { TimedQueue } from '../../util/TimedQueue';
import { Value } from '../../messages/Value';
import { Defer } from '../../../../util/Defer';
import { Observable, of, switchMap } from 'rxjs';
export class StaticRpcClient {
    id = 1;
    buffer;
    onsend = async () => {
        throw new Error('onsend not implemented');
    };
    calls = new Map();
    constructor({ send, bufferSize = 100, bufferTime = 10 }) {
        if (send)
            this.onsend = send;
        this.buffer = new TimedQueue();
        this.buffer.itemLimit = bufferSize;
        this.buffer.timeLimit = bufferTime;
        this.buffer.onFlush = (messages) => {
            this.onsend(messages)
                .then((responses) => {
                for (const response of responses) {
                    const id = response.id;
                    const calls = this.calls;
                    const future = calls.get(id);
                    calls.delete(id);
                    if (!future)
                        continue;
                    if (response instanceof msg.ResponseCompleteMessage)
                        future.resolve(response.value?.data);
                    else if (response instanceof msg.ResponseErrorMessage)
                        future.reject(response.value?.data);
                }
            })
                .catch((error) => {
                for (const message of messages)
                    if (message instanceof msg.RequestCompleteMessage) {
                        const id = message.id;
                        const calls = this.calls;
                        const future = calls.get(id);
                        calls.delete(id);
                        if (!future)
                            continue;
                        future.reject(error);
                    }
            })
                .finally(() => {
                for (const message of messages)
                    if (message instanceof msg.RequestCompleteMessage)
                        this.calls.delete(message.id);
            });
        };
    }
    call$(method, data) {
        return (data instanceof Observable ? data : of(data)).pipe(switchMap((data) => this.call(method, data)));
    }
    async call(method, request) {
        const id = this.id;
        this.id = (id + 1) % 0xffff;
        const value = new Value(request, undefined);
        const message = new msg.RequestCompleteMessage(id, method, value);
        const future = new Defer();
        this.calls.set(id, future);
        this.buffer.push(message);
        return await future.promise;
    }
    notify(method, data) {
        const value = new Value(data, undefined);
        this.buffer.push(new msg.NotificationMessage(method, value));
    }
}
