import { RpcError, RpcErrorCodes } from './error';
import { RpcCaller } from './RpcCaller';
import { FunctionStreamingType, FunctionType } from '../../../../json-type/type/classes';
import { StaticRpcMethod } from '../methods/StaticRpcMethod';
import { StreamingRpcMethod } from '../methods/StreamingRpcMethod';
export class TypeRouterCaller extends RpcCaller {
    router;
    system;
    methods = new Map();
    constructor({ router, ...rest }) {
        super({
            ...rest,
            getMethod: (name) => this.get(name),
        });
        this.router = router;
        this.system = router.system;
    }
    req = null;
    res = null;
    get(id) {
        let method = this.methods.get(id);
        if (method)
            return method;
        const fn = this.router.routes[id];
        if (!fn || !(fn instanceof FunctionType || fn instanceof FunctionStreamingType))
            throw RpcError.valueFromCode(RpcErrorCodes.METHOD_NOT_FOUND, `Type [alias = ${id}] is not a function.`);
        const validator = fn.req.validator('object');
        const requestSchema = fn.req.getSchema();
        const isRequestVoid = requestSchema.__t === 'const' && requestSchema.value === undefined;
        const validate = isRequestVoid
            ? () => { }
            : (req) => {
                const error = validator(req);
                if (error) {
                    throw RpcError.value(RpcError.validation(error.message, error));
                }
            };
        method =
            fn instanceof FunctionType
                ? new StaticRpcMethod({
                    req: fn.req,
                    res: fn.res,
                    validate,
                    call: fn.singleton,
                })
                : new StreamingRpcMethod({
                    req: fn.req,
                    res: fn.res,
                    validate,
                    call$: fn.singleton,
                });
        this.methods.set(id, method);
        return method;
    }
    async call(id, request, ctx) {
        return super.call(id, request, ctx);
    }
}
