import { StreamingRpcClient } from './client/StreamingRpcClient';
export class RpcMessageStreamProcessorLocalClient extends StreamingRpcClient {
    params;
    constructor(params) {
        super({
            send: (messages) => {
                Promise.resolve().then(() => {
                    this.params.server.onMessages(messages, this.params.ctx);
                });
            },
            bufferSize: 1,
            bufferTime: 0,
        });
        this.params = params;
        this.params.server.onSend = (messages) => {
            Promise.resolve().then(() => {
                this.onMessages(messages);
            });
        };
    }
}
