import { Observable } from 'rxjs';
import * as msg from '../messages';
import { StreamingRpcClient } from './client/StreamingRpcClient';
import { RpcMessageStreamProcessor } from './RpcMessageStreamProcessor';
export interface RpcDuplexParams<Ctx = unknown> {
    client: StreamingRpcClient;
    server: RpcMessageStreamProcessor<Ctx>;
}
export declare class RpcDuplex<Ctx = unknown> {
    readonly client: StreamingRpcClient;
    readonly server: RpcMessageStreamProcessor<Ctx>;
    constructor(params: RpcDuplexParams<Ctx>);
    onMessages(messages: msg.ReactiveRpcMessage[], ctx: Ctx): void;
    onMessage(message: msg.ReactiveRpcMessage, ctx: Ctx): void;
    call$(method: string, data: unknown): Observable<unknown>;
    call$(method: string, data: Observable<unknown>): Observable<unknown>;
    call(method: string, data: unknown): Promise<unknown>;
    notify(method: string, data: undefined | unknown): void;
    stop(): void;
    disconnect(): void;
}
