import { TypeSystem } from '../../../../json-type';
export const system = new TypeSystem();
const t = system.t;
export const JsonRpc2Id = t.num.options({ format: 'i32' });
system.alias('JsonRpc2Id', JsonRpc2Id);
export const JsonRpc2Notification = t.Object(t.prop('jsonrpc', t.Const('2.0')), t.prop('method', t.str), t.propOpt('params', t.any));
system.alias('JsonRpc2Notification', JsonRpc2Notification);
export const JsonRpc2Request = t.Object(t.prop('jsonrpc', t.Const('2.0')), t.prop('id', t.Ref('JsonRpc2Id')), t.prop('method', t.str.options({
    title: 'RPC method name',
    description: 'JSON RPC 2.0 method name.',
})), t.propOpt('params', t.any));
system.alias('JsonRpc2Request', JsonRpc2Request);
export const JsonRpc2Response = t.Object(t.prop('jsonrpc', t.Const('2.0')), t.prop('id', t.Ref('JsonRpc2Id')), t.prop('result', t.any));
system.alias('JsonRpc2Response', JsonRpc2Response);
export const JsonRpc2Error = t.Object(t.prop('jsonrpc', t.Const('2.0')), t.prop('id', t.Ref('JsonRpc2Id')), t.prop('error', t.Object(t.prop('message', t.str.options({
    title: 'Error message',
    description: 'A string providing a short description of the error.',
})), t.prop('code', t.num.options({
    title: 'Error code',
    description: 'A number that indicates the error type that occurred.',
    format: 'i32',
})), t.propOpt('data', t.any.options({
    title: 'Error data',
    description: 'A Primitive or Structured value that contains additional information about the error.',
})))));
system.alias('JsonRpc2Error', JsonRpc2Error);
