import { utf8Count } from '../../../util/strings/utf8';
export const createWebSocketMock = (params) => {
    const WebSocketMock = class WebSocketMock {
        url;
        _protocol;
        static CONNECTING = 0;
        static OPEN = 1;
        static CLOSING = 2;
        static CLOSED = 3;
        CONNECTING = 0;
        OPEN = 1;
        CLOSING = 2;
        CLOSED = 3;
        onclose = null;
        onerror = null;
        onmessage = null;
        onopen = null;
        binaryType = 'blob';
        _readyState = 0;
        _bufferedAmount = 0;
        get bufferedAmount() {
            return this._bufferedAmount;
        }
        get extensions() {
            return '';
        }
        get protocol() {
            return this._protocol instanceof Array ? this._protocol.join(',') : this._protocol;
        }
        get readyState() {
            return this._readyState;
        }
        constructor(url, _protocol = '') {
            this.url = url;
            this._protocol = _protocol;
        }
        close(code, reason) {
            if (!params.onClose)
                return;
            return params.onClose(code, reason);
        }
        send(data) {
            if (typeof data === 'string') {
                this._bufferedAmount += utf8Count(data);
            }
            else if (ArrayBuffer.isView(data)) {
                this._bufferedAmount += data.byteLength;
            }
            else if (data && typeof data === 'object') {
                if (data.byteLength !== undefined) {
                    this._bufferedAmount += Number(data.byteLength);
                }
                else if (data.size !== undefined) {
                    this._bufferedAmount += Number(data.size);
                }
            }
            if (!params.onSend)
                return;
            return params.onSend(data);
        }
        addEventListener() {
            throw new Error('not implemented');
        }
        removeEventListener() {
            throw new Error('not implemented');
        }
        dispatchEvent() {
            throw new Error('not implemented');
        }
        _extendParams(newParams) {
            Object.assign(params, newParams);
        }
        _open() {
            this._readyState = 1;
            if (typeof this.onopen === 'function') {
                this.onopen.call(this, new Event('open'));
            }
        }
        _close(code, reason, wasClean) {
            if (this._readyState === 3)
                throw new Error('Mock WebSocket already closed.');
            this._readyState = 3;
            if (!this.onclose)
                return;
            const event = {
                code,
                reason,
                wasClean,
            };
            this.onclose.call(this, event);
        }
        _error() {
            if (!this.onerror)
                return;
            this.onerror.call(this, new Event('error'));
        }
        _message(message) {
            if (!this.onmessage)
                return;
            const event = { data: message };
            this.onmessage.call(this, event);
        }
    };
    return WebSocketMock;
};
