import * as schema from '../schema';
import { Printable } from '../../util/print/types';
import { ValidatorCodegenContext, ValidatorCodegenContextOptions } from '../codegen/validator/ValidatorCodegenContext';
import { JsonTypeValidator, ValidationPath } from '../codegen/validator/types';
import { JsonTextEncoderCodegenContext, JsonTextEncoderCodegenContextOptions, JsonEncoderFn } from '../codegen/json/JsonTextEncoderCodegenContext';
import { CompiledBinaryEncoder } from '../codegen/types';
import { CborEncoderCodegenContext, CborEncoderCodegenContextOptions } from '../codegen/binary/CborEncoderCodegenContext';
import { JsonEncoderCodegenContext, JsonEncoderCodegenContextOptions } from '../codegen/binary/JsonEncoderCodegenContext';
import { BinaryEncoderCodegenContext } from '../codegen/binary/BinaryEncoderCodegenContext';
import { JsExpression } from '../../util/codegen/util/JsExpression';
import { MessagePackEncoderCodegenContext, MessagePackEncoderCodegenContextOptions } from '../codegen/binary/MessagePackEncoderCodegenContext';
import { EncodingFormat } from '../../json-pack/constants';
import { BinaryJsonEncoder } from '../../json-pack/types';
import { CapacityEstimatorCodegenContext, CapacityEstimatorCodegenContextOptions, CompiledCapacityEstimator } from '../codegen/capacity/CapacityEstimatorCodegenContext';
import { JsonValueCodec } from '../../json-pack/codecs/types';
import type * as jsonSchema from '../../json-schema';
import type { BaseType, SchemaOf, SchemaOfObjectFields, Type } from './types';
import type { TypeSystem } from '../system/TypeSystem';
import type { json_string } from '../../json-brand';
import type * as ts from '../typescript/types';
import type { TypeExportContext } from '../system/TypeExportContext';
import type { ResolveType } from '../system';
import type { Observable } from 'rxjs';
interface Validators {
    object?: JsonTypeValidator;
    string?: JsonTypeValidator;
    boolean?: JsonTypeValidator;
}
export declare abstract class AbstractType<S extends schema.Schema> implements BaseType<S>, Printable {
    system?: TypeSystem;
    protected validators: Validators;
    protected encoders: Map<EncodingFormat, CompiledBinaryEncoder>;
    protected abstract schema: S;
    getTypeName(): S['__t'];
    getSchema(): S;
    getValidatorNames(): string[];
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaNode;
    options(options: schema.Optional<S>): this;
    getOptions(): schema.Optional<S>;
    abstract validateSchema(): void;
    validate(value: unknown): void;
    compileValidator(options: Partial<Omit<ValidatorCodegenContextOptions, 'type'>>): JsonTypeValidator;
    private __compileValidator;
    validator(kind: keyof Validators): JsonTypeValidator;
    protected compileJsonTextEncoder(options: Omit<JsonTextEncoderCodegenContextOptions, 'type'>): JsonEncoderFn;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private __jsonEncoder;
    jsonTextEncoder(): JsonEncoderFn;
    compileEncoder(format: EncodingFormat, name?: string): CompiledBinaryEncoder;
    encoder(kind: EncodingFormat): CompiledBinaryEncoder;
    encode(codec: JsonValueCodec, value: unknown): Uint8Array;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    compileCborEncoder(options: Omit<CborEncoderCodegenContextOptions, 'type' | 'encoder'>): CompiledBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    compileMessagePackEncoder(options: Omit<MessagePackEncoderCodegenContextOptions, 'type' | 'encoder'>): CompiledBinaryEncoder;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    compileJsonEncoder(options: Omit<JsonEncoderCodegenContextOptions, 'type' | 'encoder'>): CompiledBinaryEncoder;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    compileCapacityEstimator(options: Omit<CapacityEstimatorCodegenContextOptions, 'type'>): CompiledCapacityEstimator;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    private __capacityEstimator;
    capacityEstimator(): CompiledCapacityEstimator;
    random(): unknown;
    toTypeScriptAst(): ts.TsNode;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<unknown>;
    protected toStringTitle(): string;
    protected toStringOptions(): string;
    toString(tab?: string): string;
}
export declare class AnyType extends AbstractType<schema.AnySchema> {
    protected schema: schema.AnySchema;
    constructor(schema: schema.AnySchema);
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaAny;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): unknown;
    toTypeScriptAst(): ts.TsType;
}
export declare class ConstType<V = any> extends AbstractType<schema.ConstSchema<V>> {
    protected schema: schema.ConstSchema<any>;
    private __json;
    constructor(schema: schema.ConstSchema<any>);
    value(): any;
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaValueNode;
    getOptions(): schema.Optional<schema.ConstSchema<V>>;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): unknown;
    toTypeScriptAst(): ts.TsNullKeyword | ts.TsObjectKeyword | ts.TsStringLiteral | ts.TsNumericLiteral | ts.TsTrueKeyword | ts.TsFalseKeyword | ts.TsUnknownKeyword;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<V>;
    toString(tab?: string): string;
}
export declare class BooleanType extends AbstractType<schema.BooleanSchema> {
    protected schema: schema.BooleanSchema;
    constructor(schema: schema.BooleanSchema);
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaBoolean;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    protected codegenBinaryEncoder(ctx: BinaryEncoderCodegenContext<BinaryJsonEncoder>, value: JsExpression): void;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): boolean;
    toTypeScriptAst(): ts.TsBooleanKeyword;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<boolean>;
}
export declare class NumberType extends AbstractType<schema.NumberSchema> {
    protected schema: schema.NumberSchema;
    constructor(schema: schema.NumberSchema);
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaNumber;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): number;
    toTypeScriptAst(): ts.TsNumberKeyword;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<number>;
}
export declare class StringType extends AbstractType<schema.StringSchema> {
    protected schema: schema.StringSchema;
    constructor(schema: schema.StringSchema);
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaString;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): string;
    toTypeScriptAst(): ts.TsStringKeyword;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<unknown>;
}
export declare class BinaryType<T extends Type> extends AbstractType<schema.BinarySchema> {
    protected type: T;
    protected schema: schema.BinarySchema;
    constructor(type: T, options?: schema.Optional<schema.BinarySchema>);
    getSchema(): schema.BinarySchema<SchemaOf<T>>;
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaBinary;
    getOptions(): schema.Optional<schema.ArraySchema<SchemaOf<T>>>;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): Uint8Array;
    toTypeScriptAst(): ts.TsGenericTypeAnnotation;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<unknown>;
    toString(tab?: string): string;
}
export declare class ArrayType<T extends Type> extends AbstractType<schema.ArraySchema<SchemaOf<T>>> {
    protected type: T;
    protected schema: schema.ArraySchema<any>;
    constructor(type: T, options?: schema.Optional<schema.ArraySchema>);
    getSchema(ctx?: TypeExportContext): schema.ArraySchema<SchemaOf<T>>;
    toJsonSchema(): jsonSchema.JsonSchemaArray;
    getOptions(): schema.Optional<schema.ArraySchema<SchemaOf<T>>>;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): unknown[];
    toTypeScriptAst(): ts.TsArrayType;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<unknown>;
    toString(tab?: string): string;
}
export declare class TupleType<T extends Type[]> extends AbstractType<schema.TupleSchema<{
    [K in keyof T]: SchemaOf<T[K]>;
}>> {
    protected types: T;
    protected schema: schema.TupleSchema<any>;
    constructor(types: T, options?: Omit<schema.TupleSchema, '__t' | 'type'>);
    getSchema(): schema.TupleSchema<{
        [K in keyof T]: SchemaOf<T[K]>;
    }>;
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaArray;
    getOptions(): schema.Optional<schema.TupleSchema<{
        [K in keyof T]: SchemaOf<T[K]>;
    }>>;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): unknown[];
    toTypeScriptAst(): ts.TsTupleType;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<unknown>;
    toString(tab?: string): string;
}
export declare class ObjectFieldType<K extends string, V extends Type> extends AbstractType<schema.ObjectFieldSchema<K, SchemaOf<V>>> {
    readonly key: K;
    readonly value: V;
    protected schema: schema.ObjectFieldSchema<K, any>;
    constructor(key: K, value: V);
    getSchema(): schema.ObjectFieldSchema<K, SchemaOf<V>>;
    getOptions(): schema.Optional<schema.ObjectFieldSchema<K, SchemaOf<V>>>;
    validateSchema(): void;
    protected toStringTitle(): string;
    toString(tab?: string): string;
}
export declare class ObjectOptionalFieldType<K extends string, V extends Type> extends ObjectFieldType<K, V> {
    readonly key: K;
    readonly value: V;
    optional: boolean;
    constructor(key: K, value: V);
    protected toStringTitle(): string;
}
export declare class ObjectType<F extends ObjectFieldType<any, any>[]> extends AbstractType<schema.ObjectSchema<SchemaOfObjectFields<F>>> {
    protected fields: F;
    protected schema: schema.ObjectSchema<any>;
    constructor(fields: F);
    getSchema(): schema.ObjectSchema<SchemaOfObjectFields<F>>;
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaObject;
    getOptions(): schema.Optional<schema.ObjectSchema<SchemaOfObjectFields<F>>>;
    getField(key: string): ObjectFieldType<string, Type> | undefined;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): Record<string, unknown>;
    toTypeScriptAst(): ts.TsTypeLiteral;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<unknown>;
    toString(tab?: string): string;
}
export declare class RefType<T extends Type> extends AbstractType<schema.RefSchema<SchemaOf<T>>> {
    protected schema: schema.RefSchema<SchemaOf<T>>;
    constructor(ref: string);
    getRef(): string;
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaRef;
    getOptions(): schema.Optional<schema.RefSchema<SchemaOf<T>>>;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): unknown;
    toTypeScriptAst(): ts.TsGenericTypeAnnotation;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<unknown>;
    toStringTitle(tab?: string): string;
}
export declare class OrType<T extends Type[]> extends AbstractType<schema.OrSchema<{
    [K in keyof T]: SchemaOf<T[K]>;
}>> {
    protected types: T;
    protected schema: schema.OrSchema<any>;
    constructor(types: T, options?: Omit<schema.OrSchema, '__t' | 'type'>);
    getSchema(): schema.OrSchema<{
        [K in keyof T]: SchemaOf<T[K]>;
    }>;
    toJsonSchema(ctx?: TypeExportContext): jsonSchema.JsonSchemaOr;
    getOptions(): schema.Optional<schema.OrSchema<{
        [K in keyof T]: SchemaOf<T[K]>;
    }>>;
    options(options: schema.Optional<schema.OrSchema> & Pick<schema.OrSchema, 'discriminator'>): this;
    private __discriminator;
    discriminator(): (val: unknown) => number;
    validateSchema(): void;
    codegenValidator(ctx: ValidatorCodegenContext, path: ValidationPath, r: string): void;
    codegenJsonTextEncoder(ctx: JsonTextEncoderCodegenContext, value: JsExpression): void;
    private codegenBinaryEncoder;
    codegenCborEncoder(ctx: CborEncoderCodegenContext, value: JsExpression): void;
    codegenMessagePackEncoder(ctx: MessagePackEncoderCodegenContext, value: JsExpression): void;
    codegenJsonEncoder(ctx: JsonEncoderCodegenContext, value: JsExpression): void;
    codegenCapacityEstimator(ctx: CapacityEstimatorCodegenContext, value: JsExpression): void;
    random(): unknown;
    toTypeScriptAst(): ts.TsUnionType;
    toJson(value: unknown, system?: TypeSystem | undefined): json_string<unknown>;
    toString(tab?: string): string;
}
type FunctionImpl<Req extends Type, Res extends Type, Ctx = unknown> = (req: ResolveType<Req>, ctx: Ctx) => Promise<ResolveType<Res>>;
export declare class FunctionType<Req extends Type, Res extends Type> extends AbstractType<schema.FunctionSchema<SchemaOf<Req>, SchemaOf<Res>>> {
    readonly req: Req;
    readonly res: Res;
    protected schema: schema.FunctionSchema<SchemaOf<Req>, SchemaOf<Res>>;
    fn: schema.FunctionValue<schema.TypeOf<SchemaOf<Req>>, schema.TypeOf<SchemaOf<Res>>>;
    constructor(req: Req, res: Res, options?: schema.Optional<schema.FunctionSchema<SchemaOf<Req>, SchemaOf<Res>>>);
    getSchema(): schema.FunctionSchema<SchemaOf<Req>, SchemaOf<Res>>;
    validateSchema(): void;
    random(): unknown;
    singleton?: FunctionImpl<Req, Res, any>;
    implement<Ctx = unknown>(singleton: FunctionImpl<Req, Res, Ctx>): this;
    toTypeScriptAst(): ts.TsUnionType;
    toString(tab?: string): string;
}
type FunctionStreamingImpl<Req extends Type, Res extends Type, Ctx = unknown> = (req: Observable<ResolveType<Req>>, ctx: Ctx) => Observable<ResolveType<Res>>;
export declare class FunctionStreamingType<Req extends Type, Res extends Type> extends AbstractType<schema.FunctionStreamingSchema<SchemaOf<Req>, SchemaOf<Res>>> {
    readonly req: Req;
    readonly res: Res;
    readonly isStreaming = true;
    protected schema: schema.FunctionStreamingSchema<SchemaOf<Req>, SchemaOf<Res>>;
    constructor(req: Req, res: Res, options?: schema.Optional<schema.FunctionStreamingSchema<SchemaOf<Req>, SchemaOf<Res>>>);
    getSchema(): schema.FunctionStreamingSchema<SchemaOf<Req>, SchemaOf<Res>>;
    validateSchema(): void;
    random(): unknown;
    singleton?: FunctionStreamingImpl<Req, Res, any>;
    implement<Ctx = unknown>(singleton: FunctionStreamingImpl<Req, Res, Ctx>): this;
    toTypeScriptAst(): ts.TsUnionType;
    toString(tab?: string): string;
}
export {};
