import { JsonSchemaGenericKeywords } from '../../json-schema';
import type { TypeSystem } from '.';
import type { Type } from '../type';
import type { Printable } from '../../util/print/types';
import type * as ts from '../typescript/types';
export declare class TypeAlias<K extends string, T extends Type> implements Printable {
    readonly system: TypeSystem;
    readonly id: K;
    readonly type: T;
    constructor(system: TypeSystem, id: K, type: T);
    getType(): Type;
    resolve(): TypeAlias<string, Type>;
    toString(tab?: string): string;
    toTypeScriptAst(): ts.TsInterfaceDeclaration | ts.TsTypeAliasDeclaration;
    toTypeScript(): string;
    toJsonSchema(): JsonSchemaGenericKeywords;
}
