import { BooleanSchema, NumberSchema, StringSchema, ArraySchema, ObjectSchema, ObjectFieldSchema, NoT, BinarySchema, AnySchema, RefSchema, OrSchema, Schema, ObjectOptionalFieldSchema, Optional, ConstSchema, TupleSchema, FunctionSchema, FunctionStreamingSchema, TType } from '.';
export declare class SchemaBuilder {
    get str(): StringSchema;
    get num(): NumberSchema;
    get bool(): BooleanSchema;
    get undef(): ConstSchema<undefined>;
    get nil(): ConstSchema<null>;
    get arr(): ArraySchema<AnySchema>;
    get obj(): ObjectSchema<[]>;
    get bin(): BinarySchema<any>;
    get any(): AnySchema;
    get fn(): FunctionSchema<AnySchema, AnySchema>;
    get fn$(): FunctionStreamingSchema<AnySchema, AnySchema>;
    Boolean(id: string, options?: Omit<NoT<BooleanSchema>, 'id'>): BooleanSchema;
    Boolean(options?: NoT<BooleanSchema>): BooleanSchema;
    Number(options?: NoT<NumberSchema>): NumberSchema;
    String(id: string, options?: NoT<StringSchema>): StringSchema;
    String(options?: NoT<StringSchema>): StringSchema;
    Binary<T extends Schema>(type: T, options?: Optional<BinarySchema>): BinarySchema;
    Array<T extends Schema>(id: string, type: T, options?: Omit<NoT<ArraySchema<T>>, 'id' | 'type'>): ArraySchema<T>;
    Array<T extends Schema>(type: T, options?: Omit<NoT<ArraySchema<T>>, 'type'>): ArraySchema<T>;
    Const<V>(value: V, options?: Optional<ConstSchema<V>>): ConstSchema<string extends V ? never : number extends V ? never : boolean extends V ? never : any[] extends V ? never : V>;
    Tuple<T extends Schema[]>(...types: T): TupleSchema<T>;
    fields<F extends ObjectFieldSchema<any, any>[]>(...fields: ObjectSchema<F>['fields']): F;
    Object<F extends ObjectFieldSchema<string, Schema>[] | readonly ObjectFieldSchema<string, Schema>[]>(options: NoT<ObjectSchema<F>>): ObjectSchema<F>;
    Object<F extends ObjectFieldSchema<string, Schema>[] | readonly ObjectFieldSchema<string, Schema>[]>(fields: ObjectSchema<F>['fields'], options?: Optional<ObjectSchema<F>>): ObjectSchema<F>;
    Object<F extends ObjectFieldSchema<string, Schema>[] | readonly ObjectFieldSchema<string, Schema>[]>(...fields: ObjectSchema<F>['fields']): ObjectSchema<F>;
    Field<K extends string, V extends Schema>(key: K, type: V, options?: Omit<NoT<ObjectFieldSchema<K, V>>, 'key' | 'type' | 'optional'>): ObjectFieldSchema<K, V>;
    FieldOpt<K extends string, V extends Schema>(key: K, type: V, options?: Omit<NoT<ObjectFieldSchema<K, V>>, 'key' | 'type' | 'optional'>): ObjectOptionalFieldSchema<K, V>;
    prop<K extends string, V extends Schema>(key: K, type: V, options?: Omit<NoT<ObjectFieldSchema<K, V>>, 'key' | 'type' | 'optional'>): ObjectFieldSchema<K, V>;
    propOpt<K extends string, V extends Schema>(key: K, type: V, options?: Omit<NoT<ObjectFieldSchema<K, V>>, 'key' | 'type' | 'optional'>): ObjectOptionalFieldSchema<K, V>;
    Any(options?: NoT<AnySchema>): AnySchema;
    Ref<T extends TType = any>(ref: string): RefSchema<T>;
    Or<T extends Schema[]>(...types: T): OrSchema<T>;
    Function<Req extends Schema, Res extends Schema>(req: Req, res: Res): FunctionSchema<Req, Res>;
    Function$<Req extends Schema, Res extends Schema>(req: Req, res: Res): FunctionStreamingSchema<Req, Res>;
}
