import { Codegen, CodegenStepExecJs } from '../../../util/codegen';
import { asString } from '../../../util/strings/asString';
import { toBase64 } from '../../../util/base64';
class WriteTextStep {
    str;
    constructor(str) {
        this.str = str;
    }
}
export class JsonTextEncoderCodegenContext {
    options;
    codegen;
    constructor(options) {
        this.options = options;
        this.codegen = new Codegen({
            name: 'toJson' + (options.name ? '_' + options.name : ''),
            prologue: `var s = '';`,
            epilogue: `return s;`,
            processSteps: (steps) => {
                const stepsJoined = [];
                for (let i = 0; i < steps.length; i++) {
                    const step = steps[i];
                    if (step instanceof CodegenStepExecJs)
                        stepsJoined.push(step);
                    else if (step instanceof WriteTextStep) {
                        const last = stepsJoined[stepsJoined.length - 1];
                        if (last instanceof WriteTextStep)
                            last.str += step.str;
                        else
                            stepsJoined.push(step);
                    }
                }
                const execSteps = [];
                for (const step of stepsJoined) {
                    if (step instanceof CodegenStepExecJs) {
                        execSteps.push(step);
                    }
                    else if (step instanceof WriteTextStep) {
                        const js = `s += ${JSON.stringify(step.str)};`;
                        execSteps.push(new CodegenStepExecJs(js));
                    }
                }
                return execSteps;
            },
        });
        this.codegen.linkDependency(asString, 'asString');
        this.codegen.linkDependency(JSON.stringify, 'stringify');
    }
    js(js) {
        this.codegen.js(js);
    }
    writeText(str) {
        this.codegen.step(new WriteTextStep(str));
    }
    base64Linked = false;
    linkBase64() {
        if (this.base64Linked)
            return;
        this.codegen.linkDependency(toBase64, 'toBase64');
    }
    compile() {
        return this.codegen.compile();
    }
}
