import { Codegen, CodegenStepExecJs } from '../../../util/codegen';
import { maxEncodingCapacity } from '../../../json-size';
import { Value } from '../../../reactive-rpc/common/messages/Value';
class IncrementSizeStep {
    inc;
    constructor(inc) {
        this.inc = inc;
    }
}
export class CapacityEstimatorCodegenContext {
    options;
    codegen;
    constructor(options) {
        this.options = options;
        this.codegen = new Codegen({
            name: 'approxSize' + (options.name ? '_' + options.name : ''),
            args: ['r0'],
            prologue: `var size = 0;`,
            epilogue: `return size;`,
            linkable: {
                Value,
            },
            processSteps: (steps) => {
                const stepsJoined = [];
                for (let i = 0; i < steps.length; i++) {
                    const step = steps[i];
                    if (step instanceof CodegenStepExecJs)
                        stepsJoined.push(step);
                    else if (step instanceof IncrementSizeStep) {
                        stepsJoined.push(new CodegenStepExecJs(`size += ${step.inc};`));
                    }
                }
                return stepsJoined;
            },
        });
        this.codegen.linkDependency(maxEncodingCapacity, 'maxEncodingCapacity');
    }
    inc(inc) {
        this.codegen.step(new IncrementSizeStep(inc));
    }
    compile() {
        return this.codegen.compile();
    }
}
