import { Codegen } from '../../../util/codegen';
import type { TypeSystem } from '../../system';
import type { Type } from '../../type';
import type { CompiledBinaryEncoder } from '../types';
import type { BinaryJsonEncoder } from '../../../json-pack/types';
export interface BinaryEncoderCodegenContextOptions<Encoder extends BinaryJsonEncoder> {
    type: Type;
    encoder: Encoder;
    system?: TypeSystem;
    name?: string;
}
export declare class BinaryEncoderCodegenContext<Encoder extends BinaryJsonEncoder> {
    readonly options: BinaryEncoderCodegenContextOptions<Encoder>;
    readonly codegen: Codegen<CompiledBinaryEncoder>;
    constructor(options: BinaryEncoderCodegenContextOptions<Encoder>);
    getBigIntStr(arr: Uint8Array, offset: number): string;
    private codegenBlob;
    js(js: string): void;
    gen(callback: (encoder: Encoder) => void): Uint8Array;
    blob(arr: Uint8Array): void;
    compile(): CompiledBinaryEncoder;
}
